/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.create.EditRevisionsAction;
import com.atlassian.fecru.util.EggTimer;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.revision.source.PatchSource;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.util.PatchAnchorHelper;
import com.cenqua.crucible.view.PatchDO;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.perforce.P4RepositoryEngine;
import com.cenqua.fisheye.util.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class AnchorPatchAjaxAction
extends EditRevisionsAction
implements AjaxResponse {
    private Integer patchId;
    private String anchorSource;
    private int stripCount;
    private String anchorPath;
    private boolean worked;
    private String errorMsg;
    private PatchDO patchDO;
    private Patch patch;
    private boolean search;
    private boolean allrepos;
    private PatchAnchorHelper patchAnchorHelper = new PatchAnchorHelper();
    private boolean retryRepo;
    private boolean retryPath;
    private List<Pair<Path, Integer>> candidateRoots = new ArrayList<Pair<Path, Integer>>();
    private int candidateStripCount;
    private String candidateSource;
    private boolean anchorSucceeded;
    private boolean showCandidatePaths;
    private static final int INITIAL_SEARCH_TIMEOUT_SECONDS = 3;
    private static final int SECONDARY_SEARCH_TIMEOUT_SECONDS = 30;
    private static final int CANDIDATE_PATHS_TIMEOUT_SECONDS = 30;

    public AnchorPatchAjaxAction() {
        this.patchAnchorHelper = new PatchAnchorHelper();
    }

    @VisibleForTesting
    AnchorPatchAjaxAction(PatchAnchorHelper patchAnchorHelper, PermissionManager permissionManager, PatchManager patchManager) {
        this.patchAnchorHelper = patchAnchorHelper;
        this.permissionManager = permissionManager;
        this.patchManager = patchManager;
    }

    @Override
    public String getEditMode() {
        return "patch";
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    public boolean isAnchorSucceeded() {
        return this.anchorSucceeded;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Integer getPatchId() {
        return this.patchId;
    }

    public void setPatchId(Integer patchId) {
        this.patchId = patchId;
    }

    public String getAnchorSource() {
        return this.anchorSource;
    }

    public void setAnchorSource(String anchorSource) {
        this.anchorSource = anchorSource;
    }

    public int getStripCount() {
        return this.stripCount;
    }

    public void setStripCount(int stripCount) {
        this.stripCount = stripCount;
    }

    public String getAnchorPath() {
        return this.anchorPath;
    }

    public void setAnchorPath(String anchorPath) {
        if ("/".equals(anchorPath)) {
            anchorPath = "";
        }
        this.anchorPath = anchorPath;
    }

    public void setSearch(boolean search) {
        this.search = search;
    }

    public boolean isAllrepos() {
        return this.allrepos;
    }

    public void setAllrepos(boolean allrepos) {
        this.allrepos = allrepos;
    }

    public void setShowCandidatePaths(boolean showCandidatePaths) {
        this.showCandidatePaths = showCandidatePaths;
    }

    public boolean isShowCandidatePaths() {
        return this.showCandidatePaths;
    }

    @Override
    public String execute() throws Exception {
        this.clearErrorsAndMessages();
        if (!this.isFileModifiable()) {
            return "AccessError";
        }
        Patch patch = this.getPatch();
        if (patch != null && patch.getReview().equals(this.getReview())) {
            return this.txTemplate.execute(status -> {
                if (this.showCandidatePaths) {
                    RepositorySource anchorSource = (RepositorySource)this.sourceFactory.getSource(this.getAnchorSource(), this.getPrincipal());
                    if (!this.populateCandidates(anchorSource, new EggTimer(30L, TimeUnit.SECONDS))) {
                        this.addActionError("The search for usable paths took too long and was stopped. You will not be able to anchor this patch.");
                    }
                } else if (this.search) {
                    Source searchSource;
                    Source source = searchSource = Strings.isNullOrEmpty((String)this.getAnchorSource()) ? null : this.sourceFactory.getSource(this.getAnchorSource(), this.getPrincipal());
                    if (searchSource == null) {
                        searchSource = this.getSource();
                    }
                    EggTimer timer = new EggTimer(this.allrepos ? 3L : 30L, TimeUnit.SECONDS);
                    PatchSource patchSource = (PatchSource)this.sourceFactory.getSource("PATCH:" + patch.getId(), this.getPrincipal());
                    PatchAnchorHelper.PatchAnchorResult anchorResult = this.allrepos ? this.findSourceAndAnchor(patchSource, timer, searchSource) : (searchSource != null ? this.patchAnchorHelper.anchorPatch(this.contentManager, patch, patchSource, searchSource, timer) : PatchAnchorHelper.SOURCE_FIND_ERROR);
                    boolean populateCandidatePathsOnError = !this.allrepos;
                    this.showCandidatePaths = !anchorResult.worked && !this.allrepos;
                    this.handleAnchorResult(anchorResult, populateCandidatePathsOnError);
                    if (!anchorResult.worked) {
                        status.setRollbackOnly();
                    }
                    this.anchorSucceeded = anchorResult.worked;
                } else if (!Strings.isNullOrEmpty((String)this.getAnchorSource())) {
                    if (!this.getAnchorSource().equals(patch.getAnchorSource()) || !this.getAnchorPath().equals(patch.getAnchorPath())) {
                        PatchSource patchSource = (PatchSource)this.sourceFactory.getSource("PATCH:" + patch.getId(), this.getPrincipal());
                        RepositorySource anchorSource = (RepositorySource)this.sourceFactory.getSource(this.getAnchorSource(), this.getPrincipal());
                        PatchAnchorHelper.PatchAnchorResult anchorResult = this.patchAnchorHelper.anchorPatchRevisions(this.contentManager, patch, patchSource, anchorSource, this.getStripCount(), this.getAnchorPath());
                        this.handleAnchorResult(anchorResult);
                        if (!anchorResult.worked) {
                            status.setRollbackOnly();
                        }
                        this.anchorSucceeded = anchorResult.worked;
                    } else {
                        this.anchorSucceeded = true;
                    }
                } else {
                    this.patchAnchorHelper.unanchorPatch(patch);
                    this.anchorSucceeded = true;
                    this.showCandidatePaths = true;
                }
                this.worked = true;
                return "success";
            });
        }
        this.errorMsg = "Patch " + this.getPatchId() + " was not found in review " + this.getReview().getPermaId() + ".";
        return "error";
    }

    private PatchAnchorHelper.PatchAnchorResult findSourceAndAnchor(PatchSource patchSource, EggTimer timer, Source primarySource) throws IOException {
        Collection<Source> sources = this.sourceFactory.getSources(this.getPrincipal());
        return this.patchAnchorHelper.findSourceAndAnchorPatch(this.contentManager, this.patch, patchSource, sources, timer, Optional.ofNullable(primarySource));
    }

    private void handleAnchorResult(PatchAnchorHelper.PatchAnchorResult anchorResult) throws IOException {
        this.handleAnchorResult(anchorResult, false);
    }

    private void handleAnchorResult(PatchAnchorHelper.PatchAnchorResult anchorResult, boolean populateCandidatesOnError) throws IOException {
        if (!anchorResult.worked) {
            this.errorMsg = anchorResult.errorMsg;
            this.retryRepo = true;
            boolean populatingCandidatesFailed = false;
            if (populateCandidatesOnError) {
                boolean bl = populatingCandidatesFailed = !this.populateCandidates(anchorResult.anchorSource, new EggTimer(30L, TimeUnit.SECONDS));
            }
            if (populatingCandidatesFailed) {
                this.addActionError(anchorResult.errorMsg + " Finding alternate paths took too long - you will not be able to anchor this patch.");
            } else {
                this.addActionError(anchorResult.errorMsg + " You will not be able to do iterative reviews on this patch without anchoring it.");
            }
        } else {
            this.addActionMessage("Your patch has been successfully anchored to '" + anchorResult.anchorSource.getName() + "'");
        }
    }

    private boolean populateCandidates(RepositorySource anchorSource, EggTimer timer) throws IOException {
        Pair<Integer, Map<Path, Integer>> rootsPair;
        if (anchorSource != null && (anchorSource.getRepoEngine() instanceof Svn2RepositoryEngine || anchorSource.getRepoEngine() instanceof P4RepositoryEngine) && (rootsPair = anchorSource.getRootPaths(this.patch, timer)) != null && rootsPair.getSecond().size() > 0) {
            this.candidateSource = anchorSource.getName();
            this.retryPath = true;
            this.candidateStripCount = rootsPair.getFirst();
            for (Map.Entry<Path, Integer> entry : rootsPair.getSecond().entrySet()) {
                this.candidateRoots.add(Pair.newInstance(entry.getKey(), entry.getValue()));
            }
            Collections.sort(this.candidateRoots, PatchAnchorHelper.ROOTS_COMPARATOR);
        }
        return !timer.isTimeExpired();
    }

    public Patch getPatch() {
        if (this.patch == null) {
            this.patch = this.patchManager.getPatchById(this.getPatchId());
        }
        return this.patch;
    }

    public PatchDO getPatchDO() {
        if (this.patchDO == null) {
            this.patchDO = new PatchDO(this.getPatch(), this.getPrincipal(), this.sourceFactory);
        }
        return this.patchDO;
    }

    public boolean getRetryRepo() {
        return this.retryRepo;
    }

    public Boolean getRetryPath() {
        return this.retryPath;
    }

    public List<Pair<Path, Integer>> getCandidateRoots() {
        return this.candidateRoots;
    }

    public int getCandidateStripCount() {
        return this.candidateStripCount;
    }

    public String getCandidateSource() {
        return this.candidateSource;
    }
}

