/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.create.EditRevisionsAction;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.UserProfileManager;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.UploadSource;
import com.cenqua.crucible.view.UploadDO;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.google.common.base.Strings;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;

public abstract class AddUploadBaseAction
extends EditRevisionsAction {
    private File upload;
    private String uploadFileName;
    private String uploadText;
    private String uploadContentType;
    private String charset;
    private List<UploadDO> uploadDOs;
    private UserProfile userProfile;
    @Resource
    private UserProfileManager userProfileManager;
    @Resource
    private RootConfig rootConfig;

    public UserProfileManager getUserProfileManager() {
        return this.userProfileManager;
    }

    public UserProfile getUserProfile() {
        if (this.userProfile == null) {
            try {
                this.userProfile = this.getUserProfileManager().getProfile(this.getCurrentUser().getUsername());
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)("Could not save preferences for user: " + this.getCurrentUser().getUsername()));
                this.userProfile = this.getUserProfileManager().getDefaultProfile();
            }
        }
        return this.userProfile;
    }

    public boolean isStickyPatch() {
        return "patch".equals(this.getUserProfile().getUploadType());
    }

    public boolean isStickyFile() {
        return "file".equals(this.getUserProfile().getUploadMethod());
    }

    public String getStickyCharset() {
        String stickyCharset = this.getUserProfile().getUploadCharset();
        return Strings.isNullOrEmpty((String)stickyCharset) ? this.getDefaultCharset() : stickyCharset;
    }

    public File getUpload() {
        return this.upload;
    }

    public void setUpload(File upload) {
        this.upload = upload;
    }

    public String getUploadFileName() {
        return this.uploadFileName;
    }

    public void setUploadFileName(String uploadFileName) {
        this.uploadFileName = uploadFileName;
    }

    public String getUploadText() {
        return this.uploadText;
    }

    public void setUploadText(String uploadText) {
        this.uploadText = uploadText;
    }

    public String getUploadContentType() {
        String ourContentType = this.rootConfig.getRawMimeMap().getContentTypeFor(this.uploadFileName);
        if (ourContentType != null) {
            this.uploadContentType = ourContentType;
        }
        if (this.upload != null && !Strings.isNullOrEmpty((String)this.uploadContentType)) {
            return this.uploadContentType;
        }
        return "text/plain";
    }

    public void setUploadContentType(String uploadContentType) {
        this.uploadContentType = uploadContentType;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    protected void updateProfile(String method, String charset) {
        try {
            UserProfile profile = this.getUserProfileManager().getProfile(this.getCurrentUser().getUsername());
            profile.setUploadMethod(method);
            profile.setUploadCharset(charset);
            this.getUserProfileManager().setProfile(this.getCurrentUser().getUsername(), profile);
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)("Could not save preferences for user: " + this.getCurrentUser().getUsername()));
        }
    }

    public boolean isPatchExists() {
        return !this.getPatches().isEmpty();
    }

    protected String findCharset() {
        String charset;
        if (this.getCharset() != null) {
            return this.getCharset();
        }
        try {
            charset = this.getCharsetFromContentType(this.getUploadContentType());
        }
        catch (ParseException e2) {
            Logs.APP_LOG.debug((Object)"Parse Exception", (Throwable)e2);
            charset = null;
        }
        if (charset == null) {
            charset = Charset.defaultCharset().name();
        }
        return charset;
    }

    private String getCharsetFromContentType(String contentType) throws ParseException {
        ContentType type = new ContentType(contentType);
        return type.getParameter("charset");
    }

    public Collection<String> getAvailableCharsets() {
        return Charset.availableCharsets().keySet();
    }

    public String getDefaultCharset() {
        return Charset.defaultCharset().name();
    }

    @Override
    public List<String> getIdsToRemove() {
        ArrayList<String> result = new ArrayList<String>();
        List<Patch> patches = this.getPatches();
        for (Patch patch : patches) {
            result.add("'PATCH:" + patch.getId() + "'");
        }
        return result;
    }

    public List<UploadDO> getUploadDOs() {
        if (this.uploadDOs == null) {
            String sourceName = "UPLOAD:" + this.getReview().getId();
            UploadSource source = (UploadSource)this.sourceFactory.getSource(sourceName, this.getPrincipal());
            this.uploadDOs = new ArrayList<UploadDO>();
            List<CrucibleRevision> uploadFiles = this.getUploadFiles();
            Collections.sort(uploadFiles, new Comparator<CrucibleRevision>(){

                @Override
                public int compare(CrucibleRevision left, CrucibleRevision right) {
                    int comparison = left.getPath().compareTo(right.getPath());
                    return comparison == 0 ? left.getId().compareTo(right.getId()) : comparison;
                }
            });
            ArrayList<CrucibleRevision> allUploadRevisionsInReview = new ArrayList<CrucibleRevision>();
            for (FileRevisionExtraInfo frx : this.getReview().getFrxs()) {
                if (!frx.getFileRevision().getSourceName().equals(sourceName)) continue;
                for (FRXRevision revision : frx.getFrxRevisions()) {
                    allUploadRevisionsInReview.add(revision.getRevision());
                }
            }
            while (uploadFiles.size() > 0) {
                CrucibleRevision cruRev = uploadFiles.get(0);
                uploadFiles.remove(cruRev);
                if (allUploadRevisionsInReview.contains(cruRev)) {
                    this.uploadDOs.add(new UploadDO(cruRev, true));
                    continue;
                }
                RevInfoKey diffRevKey = this.contentManager.getDiffRevKeyFromCache(cruRev);
                CrucibleRevision ancestorRev = diffRevKey == null ? null : this.contentManager.getCrucibleRevision(source, diffRevKey);
                this.uploadDOs.add(new UploadDO(cruRev, false));
                if (ancestorRev == null || !uploadFiles.contains(ancestorRev)) continue;
                this.uploadDOs.add(new UploadDO(ancestorRev, false));
                uploadFiles.remove(ancestorRev);
            }
        }
        return this.uploadDOs;
    }

    public Collection getFrxs() {
        return this.getReview().getFrxs();
    }

    public boolean isUploadExists() {
        return !this.getUploadFiles().isEmpty();
    }

    public void setContentManager(ContentManager contentManager) {
        this.contentManager = contentManager;
    }
}

