/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.create.AddUploadBaseAction;
import com.atlassian.crucible.spi.ReviewServiceInternal;
import com.atlassian.crucible.spi.data.PatchData;
import com.atlassian.crucible.spi.rpc.util.FileDataBuilder;
import com.atlassian.crucible.spi.services.FileData;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.view.PatchDO;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Strings;
import java.util.Collection;
import javax.annotation.Resource;

public class AddPatchAction
extends AddUploadBaseAction {
    private String errorMessage = null;
    private boolean anchorFailed = false;
    private Integer uploadedPatchId;
    private String linkedSourceName;
    private String pathExcess;
    private String pathMissing;
    private Integer patchId;
    private String patchAction;
    private String patchSource;
    @Resource
    public ReviewServiceInternal reviewServiceInternal;

    public String getLinkedSourceName() {
        return this.linkedSourceName;
    }

    public void setLinkedSourceName(String linkedSourceName) {
        this.linkedSourceName = linkedSourceName;
    }

    public String getPathExcess() {
        return this.pathExcess;
    }

    public void setPathExcess(String pathExcess) {
        this.pathExcess = pathExcess;
    }

    public String getPathMissing() {
        return this.pathMissing;
    }

    public void setPathMissing(String pathMissing) {
        this.pathMissing = pathMissing;
    }

    public boolean isAnchorFailed() {
        return this.anchorFailed;
    }

    public Integer getUploadedPatchId() {
        return this.uploadedPatchId;
    }

    public PatchDO getUploadedPatchDO() {
        return this.uploadedPatchId == null ? null : new PatchDO(this.patchManager.getPatchById(this.uploadedPatchId), this.getPrincipal(), this.sourceFactory);
    }

    public void setUploadedPatchId(Integer uploadedPatchId) {
        this.uploadedPatchId = uploadedPatchId;
    }

    public Integer getPatchId() {
        return this.patchId;
    }

    public void setPatchId(Integer patchId) {
        this.patchId = patchId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String doView() {
        if (!this.isFileModifiable()) {
            return "AccessError";
        }
        return "success";
    }

    @Override
    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        return this.doView();
    }

    public String doUpload() throws Exception {
        if (this.getUpload() == null && Strings.isNullOrEmpty((String)this.getUploadText())) {
            return "success";
        }
        try {
            PatchData patchData;
            if (this.getUpload() != null) {
                this.updateProfile("file", this.getCharset());
                FileData fileData = FileDataBuilder.create(this.getUpload()).name(this.getUploadFileName()).description(this.getUploadFileName()).charSet(this.findCharset()).build();
                patchData = this.reviewServiceInternal.uploadPatchToReview(this.getReview().getPermId(), fileData);
            } else {
                this.updateProfile("text", this.getCharset());
                patchData = this.reviewServiceInternal.uploadPatchToReview(this.getReview().getPermId(), this.getUploadText());
            }
            this.uploadedPatchId = patchData.getId();
            String string = "success";
            return string;
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Error adding patch", (Throwable)e2);
            this.addActionError("Error adding patch: " + e2.getMessage());
            String string = "error";
            return string;
        }
        finally {
            this.setReviewid(this.getReviewid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addPatch() throws Exception {
        if (!this.isFileModifiable()) {
            return "AccessError";
        }
        String uploadItemName = this.patchManager.getPatchById(this.uploadedPatchId).getUploadItem().getOriginalName();
        boolean isAdd = "add".equals(this.patchAction);
        try {
            this.reviewServiceInternal.completeUploadPatchToReview(this.getReview().getPermId(), this.uploadedPatchId, this.patchSource, isAdd);
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Error adding patch", (Throwable)e2);
            this.addActionError("Error adding patch: " + e2.getMessage());
            String string = "error";
            return string;
        }
        finally {
            this.setReviewid(this.getReviewid());
        }
        this.uploadedPatchId = null;
        this.addActionMessage(String.format("Successfully added patch %s as %s", uploadItemName, isAdd ? "an iteration" : "a new patch"));
        return "success";
    }

    @Override
    public Collection getFrxs() {
        return this.getReview().getFrxs();
    }

    @Override
    public String getEditMode() {
        return "patch";
    }

    public String getPatchAction() {
        return this.patchAction;
    }

    public void setPatchAction(String patchAction) {
        this.patchAction = patchAction;
    }

    public String getPatchSource() {
        return this.patchSource;
    }

    public void setPatchSource(String patchSource) {
        this.patchSource = patchSource;
    }
}

