/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.create;

import com.atlassian.crucible.actions.create.AddUploadBaseAction;
import com.atlassian.crucible.spi.rpc.util.FileDataBuilder;
import com.atlassian.crucible.spi.services.FileData;
import com.atlassian.crucible.spi.services.ReviewService;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Strings;
import java.io.File;
import javax.annotation.Resource;

public class AddFileAction
extends AddUploadBaseAction {
    private String uploadTextDiff;
    private File uploadDiff;
    private String uploadDiffContentType;
    private String errorMessage = null;
    @Resource
    private ReviewService reviewService;

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public File getUploadDiff() {
        return this.uploadDiff;
    }

    public void setUploadDiff(File uploadDiff) {
        this.uploadDiff = uploadDiff;
    }

    public String getUploadTextDiff() {
        return this.uploadTextDiff;
    }

    public void setUploadTextDiff(String uploadTextDiff) {
        this.uploadTextDiff = uploadTextDiff;
    }

    public String getUploadDiffContentType() {
        if (this.uploadDiff != null && !Strings.isNullOrEmpty((String)this.uploadDiffContentType)) {
            return this.uploadDiffContentType;
        }
        return "text/plain";
    }

    public void setUploadDiffContentType(String uploadDiffContentType) {
        this.uploadDiffContentType = uploadDiffContentType;
    }

    @Override
    public String getErrorDescription() {
        return "error.unauthorized.change.description";
    }

    @Override
    public String getError() {
        return "error.unauthorized.action";
    }

    public String doUpload() {
        if (!this.isFileModifiable()) {
            return "AccessError";
        }
        try {
            if (this.getUpload() == null) {
                return this.doView();
            }
            FileData file = FileDataBuilder.create(this.getUpload()).contentType(this.getUploadContentType()).charSet(this.getCharset()).name(this.getUploadFileName()).build();
            FileData diff = null;
            if (this.uploadDiff != null) {
                diff = FileDataBuilder.create(this.uploadDiff).contentType(this.getUploadDiffContentType()).charSet(this.getCharset()).name(this.getUploadFileName()).build();
            }
            this.reviewService.addFileToReview(this.getReview().getPermId(), file, diff);
            this.updateProfile("file", this.getCharset());
            return this.doView();
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Error adding patch", (Throwable)e2);
            this.addActionError("Error adding patch: " + e2.getMessage());
            return "error";
        }
    }

    @Override
    public String getEditMode() {
        return "upload";
    }

    @Override
    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        return this.doView();
    }
}

