/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.content;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Disposer;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;

public class RawContentAction
extends ReviewBaseAction {
    private static final Pattern PATH_PROG = Pattern.compile("^/?([0-9]+)(/.*)?$");
    @Resource(name="contentManager")
    private ContentManager contentManager;
    private String actionPathInfo;
    private String contentType = "text/plain";
    private InputStream inputStream;

    public void setActionPathInfo(String actionPathInfo) {
        this.actionPathInfo = actionPathInfo;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getContentType() {
        return this.contentType;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        if (!ReviewUtil.canDoReviewAction(UserActionManager.ACTION_VIEW, this.getReview())) {
            return "nopermission";
        }
        Matcher m2 = PATH_PROG.matcher(this.actionPathInfo);
        if (!m2.matches()) {
            return "404";
        }
        int id = Integer.parseInt(m2.group(1));
        try {
            CrucibleRevision cruRev = this.contentManager.getLazyCrucibleRevisionById(id);
            if (cruRev == null) {
                Logs.APP_LOG.info((Object)("Couldn't find CrucibleRevision with id " + id));
                return "404";
            }
            if (!this.getReview().getRevisions().contains(cruRev)) {
                Logs.APP_LOG.info((Object)("given id not in review " + id));
                return "404";
            }
            this.contentType = this.contentManager.getContentType(cruRev);
            if (this.contentType != null && this.contentType.contains("gzip")) {
                this.contentType = "application/gzip";
            }
            this.inputStream = this.contentManager.getRawContents(cruRev, this.getPrincipal(), Disposer.threadInstance());
            return "success";
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)e2.getMessage(), (Throwable)e2);
            return "none";
        }
    }
}

