/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.comment;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.comment.BaseCommentAction;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.managers.UnreadManager;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ReplyAjaxAction
extends BaseCommentAction
implements AjaxResponse {
    @Autowired
    private UnreadManager unreadManager;
    private Integer replyToId;
    private Comment reply;
    private Integer frxId;
    private String type;
    private List<Integer> readCommentIds = new ArrayList<Integer>();

    @Override
    public Integer getFrxId() {
        return this.frxId;
    }

    @Override
    public int getCommentCountDelta() {
        return this.reply.isDraft() || !this.newComment && !this.wasDraft ? 0 : 1;
    }

    public Integer getReplyToId() {
        return this.replyToId;
    }

    public void setReplyToId(Integer replyToId) {
        this.replyToId = replyToId;
    }

    public Comment getReply() {
        return this.reply;
    }

    public String getType() {
        return this.type;
    }

    public List<Integer> getReadCommentIds() {
        return this.readCommentIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        try {
            this.beginTx();
            if (!this.isAllowed()) {
                this.setErrorMsg("Sorry, you're not authorized to add a reply to this comment.");
                String string = "error";
                return string;
            }
            this.reply = this.makeComment();
            if (this.reply == null) {
                String string = "error";
                return string;
            }
            Comment parent = this.commentManager.getById(this.replyToId);
            if (parent == null) {
                this.setErrorMsg("Can't find the comment you are replying to, it may have been deleted. (" + this.replyToId + ")");
                String string = "error";
                return string;
            }
            if (!this.draft && !parent.isVisibleToAll()) {
                this.setErrorMsg("Can't post replies to drafts.");
                String string = "error";
                return string;
            }
            if (parent.isDeleted()) {
                this.setErrorMsg("Sorry, this comment has been deleted. (Please reload the page for updates)");
                String string = "error";
                return string;
            }
            parent.addComment(this.reply);
            Comment markAsReadComment = this.reply;
            while (markAsReadComment.isReply()) {
                markAsReadComment = markAsReadComment.getReplyToComment();
                if (this.unreadManager.isMarkedLeaveUnread(this.getCurrentUser(), markAsReadComment)) continue;
                this.unreadManager.markAsRead(this.getCurrentUser(), markAsReadComment);
                this.readCommentIds.add(markAsReadComment.getId());
            }
            Comment root = parent.getRootComment();
            FRXComment frxComment = this.commentManager.findFrxComment(root);
            if (frxComment != null) {
                this.frxId = frxComment.getFrx().getId();
                this.type = "revision";
            } else {
                InlineComment inlineComment = this.commentManager.findInlineComment(root);
                if (inlineComment != null) {
                    this.frxId = inlineComment.getFrx().getId();
                    this.type = "inline";
                } else {
                    this.type = "general";
                }
            }
            this.commitTx();
            this.emitCommentEvent(this.reply);
            String string = "success";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

