/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.comment;

import com.atlassian.crucible.actions.SimpleAjaxResponse;
import com.atlassian.crucible.actions.comment.BaseCommentAction;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.crucible.model.Comment;
import org.springframework.beans.factory.annotation.Autowired;

public class PublishCommentAjaxAction
extends BaseCommentAction
implements SimpleAjaxResponse {
    private Integer commentId;
    private Integer frxId;
    @Autowired
    private TxTemplate txTemplate;

    @Override
    public Integer getCommentId() {
        return this.commentId;
    }

    @Override
    public void setCommentId(Integer commentId) {
        this.commentId = commentId;
    }

    @Override
    public Integer getFrxId() {
        return this.frxId;
    }

    @Override
    public int getCommentCountDelta() {
        return 1;
    }

    @Override
    public int getValue() {
        return 0;
    }

    public String execute() {
        return this.txTemplate.execute(status -> {
            if (!this.isAllowed()) {
                this.setErrorMsg("Sorry, you're not authorized to post a comment to this review now.");
                return "error";
            }
            if (this.commentId == null) {
                this.setErrorMsg("Your comment can't be posted because there was no comment ID");
                return "error";
            }
            Comment comment = this.commentManager.getById(this.commentId);
            if (comment == null) {
                this.setErrorMsg("Your comment can't be posted because it no longer exists.");
                return "error";
            }
            if (comment.getUser().equals(this.getCurrentUser())) {
                comment.setUpdatedDateTime(System.currentTimeMillis());
                try {
                    this.commentManager.publishCommentAndAnnounce(comment);
                }
                catch (IllegalArgumentException e2) {
                    this.setErrorMsg(e2.getMessage());
                    return "error";
                }
            }
            this.frxId = this.getRootFrxId(comment);
            return "success";
        });
    }
}

