/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.comment;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.comment.BaseCommentAction;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.managers.FRXCommentManager;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FRXRevisionManager;
import com.cenqua.crucible.model.managers.InlineCommentManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.util.LineRangeUtil;
import com.cenqua.crucible.view.FRXCommentDO;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.crucible.view.InlineCommentDetailDO;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Strings;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class FRXCommentAjaxAction
extends BaseCommentAction
implements AjaxResponse {
    private final FRXRevisionManager frxRevisionManager = new FRXRevisionManager();
    private String toLineRange;
    private String fromLineRange;
    private FileRevisionExtraInfo frx;
    private FRXRevision toFrxRevision;
    private FRXRevision fromFrxRevision;
    private Comment comment;
    private FRXDO frxDO;
    private FRXComment wholeRev;
    @Autowired
    private UnreadManager unreadManager;

    public void setFrxId(Integer frxId) {
        this.frx = FRXManager.getById(frxId);
        this.updateFrx();
    }

    public void setFromFrxRevisionId(Integer id) {
        this.fromFrxRevision = this.frxRevisionManager.getById(id);
        this.updateFrx();
    }

    public void setToFrxRevisionId(Integer id) {
        this.toFrxRevision = this.frxRevisionManager.getById(id);
        this.updateFrx();
    }

    private void updateFrx() {
        try {
            if (this.frx != null && this.getFrxDO() != null) {
                if (this.fromFrxRevision != null) {
                    this.frxDO.setFromFrxRevision(this.fromFrxRevision);
                }
                if (this.toFrxRevision != null) {
                    this.frxDO.setToFrxRevision(this.toFrxRevision);
                }
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"problem updating FRX", (Throwable)e2);
        }
    }

    public void setToLineRange(String toLineRange) {
        this.toLineRange = LineRangeUtil.filterLineString(toLineRange);
    }

    public void setFromLineRange(String fromLineRange) {
        this.fromLineRange = LineRangeUtil.filterLineString(fromLineRange);
    }

    public FRXDO getFrxDO() {
        if (this.frxDO == null) {
            this.frxDO = this.makeFRXDO(this.frx, false);
        }
        return this.frxDO;
    }

    public InlineCommentDetailDO getIcDO() throws Exception {
        return this.getFrxDO().getIcDOFromComment(this.comment);
    }

    @Override
    public Integer getFrxId() {
        return this.frx.getId();
    }

    @Override
    public int getCommentCountDelta() {
        return this.comment.isDraft() || !this.newComment && !this.wasDraft ? 0 : 1;
    }

    public boolean isWhole() {
        return this.wholeRev != null;
    }

    public FRXCommentDO getWholeRevisionComment() {
        return new FRXCommentDO(this.unreadManager, this.getCurrentUser(), this.getPrincipal(), this.currentUserPermissions, this.wholeRev);
    }

    public Comment getComment() {
        return this.comment;
    }

    public String execute() {
        try {
            boolean isFrxComment;
            this.beginTx();
            if (!this.isAllowed()) {
                this.setErrorMsg("Sorry, you're not authorized to add a comment to this review now.");
                String string = "error";
                return string;
            }
            this.comment = this.makeComment();
            if (this.comment == null) {
                String string = "error";
                return string;
            }
            boolean bl = isFrxComment = Strings.isNullOrEmpty((String)this.toLineRange) && Strings.isNullOrEmpty((String)this.fromLineRange);
            if (isFrxComment) {
                this.createFrxComment();
            } else {
                if (!Strings.isNullOrEmpty((String)this.toLineRange) && this.toFrxRevision == null) {
                    this.setErrorMsg("FRX Revision cannot be null if a line range is specified");
                    String string = "error";
                    return string;
                }
                this.createInlineComment();
                this.getFrxDO().mapInlineComments();
            }
            this.commitTx();
            this.emitCommentEvent(this.comment);
            String string = "success";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    private void createFrxComment() {
        this.wholeRev = FRXCommentManager.createAndAddFrxComment(this.comment, this.frx);
    }

    private void createInlineComment() {
        HashMap<FRXRevision, String> revisionLineRanges = new HashMap<FRXRevision, String>();
        if (this.toFrxRevision != null) {
            revisionLineRanges.put(this.toFrxRevision, this.toLineRange);
        }
        if (this.fromFrxRevision != null && !this.fromFrxRevision.equals(this.toFrxRevision)) {
            revisionLineRanges.put(this.fromFrxRevision, this.fromLineRange);
        }
        InlineCommentManager.createInlineComment(this.frx, this.comment, revisionLineRanges);
    }
}

