/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.comment;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.crucible.actions.SimpleAjaxResponse;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import org.springframework.beans.factory.annotation.Autowired;

public class DraftCommentsAjaxAction
extends ReviewBaseAction
implements SimpleAjaxResponse {
    private boolean worked = true;
    private String errorMsg;
    private String action;
    @Autowired
    private CommentManager commentManager;
    @Autowired
    private TxTemplate txTemplate;

    public void setAction(String action) {
        this.action = action;
    }

    public String execute() {
        return this.txTemplate.execute(status -> {
            if (!this.isCommentingAllowed()) {
                this.errorMsg = "Sorry, you're not authorized to post a comment to this review now.";
                return "error";
            }
            Review review = this.getReview();
            if (!review.getState().isReviewState()) {
                this.errorMsg = "Can't modify draft comments since " + this.getPermaId() + " is not currently under review.";
                this.worked = false;
                return "error";
            }
            switch (this.action) {
                case "publish": {
                    this.commentManager.publishDraftCommentsAndAnnounce(review, this.getCurrentUser());
                    break;
                }
                default: {
                    this.errorMsg = "Unrecognized action.";
                    this.worked = false;
                    return "error";
                }
            }
            this.worked = true;
            return "success";
        });
    }

    @Override
    public String getPayload() {
        return "";
    }

    @Override
    public int getValue() {
        return 0;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }
}

