/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.comment;

import com.atlassian.crucible.actions.SimpleAjaxResponse;
import com.atlassian.crucible.actions.comment.BaseCommentAction;
import com.atlassian.fisheye.jira.JiraIssue;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.google.common.base.Strings;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteCommentAjaxAction
extends BaseCommentAction
implements SimpleAjaxResponse {
    private Integer commentId;
    private Integer frxId;
    private Integer commentCountDelta = 0;
    private Integer unreadCommentCountDelta = 0;
    @Autowired
    private UnreadManager unreadManager;

    @Override
    public Integer getFrxId() {
        return this.frxId;
    }

    @Override
    public int getCommentCountDelta() {
        return this.commentCountDelta;
    }

    @Override
    public int getUnreadCommentCountDelta() {
        return this.unreadCommentCountDelta;
    }

    @Override
    public Integer getCommentId() {
        return this.commentId;
    }

    @Override
    public void setCommentId(Integer commentId) {
        this.commentId = commentId;
    }

    @Override
    public int getValue() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String execute() {
        try {
            this.beginTx();
            if (!this.isAllowed()) {
                this.setErrorMsg("Sorry, you're not authorized to delete a comment from this review now.");
                String string = "error";
                return string;
            }
            if (this.commentId == null) {
                this.setErrorMsg("This comment can't be deleted because there was no comment ID.");
                String string = "error";
                return string;
            }
            Comment comment = this.commentManager.getById(this.commentId);
            if (comment == null) {
                this.setErrorMsg("Sorry, comment " + this.commentId + " doesn't exist.");
                String string = "error";
                return string;
            }
            if (comment.getUser().equals(this.getCurrentUser())) {
                try {
                    this.commentManager.deleteComment(comment);
                    if (!Strings.isNullOrEmpty((String)comment.getJiraIssueKey())) {
                        try {
                            JiraIssue result = this.jiraIssueService.getJiraIssueAggregateExceptions(comment.getJiraIssueKey(), this.getQueryContext());
                            result.delete();
                            LogManager.logJiraIssueDeleted(this.getReview(), this.getCurrentUser(), comment);
                        }
                        catch (Exception je) {
                            LogManager.logJiraIssueNotDeleted(this.getReview(), this.getCurrentUser(), comment, je.getMessage());
                        }
                        comment.setJiraIssueKey(null);
                    }
                    if (!comment.isDraft()) {
                        this.commentCountDelta = -1;
                        boolean wasRead = comment.isRead(this.getCurrentUser());
                        if (!wasRead) {
                            this.unreadCommentCountDelta = -1;
                        }
                        this.frxId = this.getRootFrxId(comment);
                    }
                    this.commitTx();
                    String wasRead = "success";
                    return wasRead;
                }
                catch (IllegalArgumentException iae) {
                    this.setErrorMsg("Unable to delete comment: " + iae.getMessage());
                    String string = "error";
                    this.rollbackTxIfNotCommited();
                    return string;
                }
            }
            this.setErrorMsg("Unable to delete comment: this comment is not yours.");
            String string = "error";
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

