/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.comment;

import com.atlassian.crucible.actions.SimpleAjaxResponse;
import com.atlassian.crucible.actions.comment.BaseCommentAction;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.fisheye.logging.Logs;
import org.springframework.beans.factory.annotation.Autowired;

public class CommentReadStatusAjaxAction
extends BaseCommentAction
implements SimpleAjaxResponse {
    @Autowired
    private UnreadManager unreadManager;
    private int commentsChanged = 0;
    private Integer[] commentIds;
    private boolean markAsRead;
    private boolean wasRead;
    private Integer frxId;
    private FecruUser user;

    @Override
    public void setCommentId(Integer commentId) {
        this.commentIds = new Integer[]{commentId};
    }

    public void setCid(Integer[] cids) {
        this.commentIds = cids;
    }

    public void setMarkAsRead(boolean read) {
        this.markAsRead = read;
    }

    @Override
    public int getValue() {
        return 0;
    }

    @Override
    public int getUnreadCommentCountDelta() {
        if (this.markAsRead) {
            return -1 * this.commentsChanged;
        }
        return this.wasRead ? this.commentsChanged : 0;
    }

    @Override
    public Integer getFrxId() {
        return this.frxId;
    }

    public String execute() {
        try {
            this.beginTx();
            if (!this.isAllowed()) {
                String string = this.bail("Sorry, you're not authorized to read/unread a comment from this review now.");
                return string;
            }
            this.user = this.getCurrentUser();
            if (this.user == null) {
                String string = this.bail("Anonymous users cannot mark comments as read/unread.");
                return string;
            }
            try {
                this.changeCommentStatuses();
            }
            catch (Exception e2) {
                String string = this.bail(e2.getMessage());
                this.rollbackTxIfNotCommited();
                return string;
            }
            this.commitTx();
            String string = "success";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    private void changeCommentStatuses() throws Exception {
        for (Integer id : this.commentIds) {
            this.changeCommentStatus(id);
        }
    }

    private void changeCommentStatus(Integer commentId) throws Exception {
        if (commentId == null) {
            throw new Exception("This comment can't be read/unread because there was no comment ID.");
        }
        Comment comment = this.commentManager.getById(commentId);
        if (comment == null) {
            throw new Exception("Comment " + commentId + " doesn't exist.");
        }
        if (comment.isDraft()) {
            throw new Exception("Draft comments can't be read/unread.");
        }
        if (comment.getUser().equals(this.user)) {
            Logs.APP_LOG.debug((Object)("Comment's author, " + this.user.getUsername() + ", cannot mark comment " + commentId + " read/unread."));
            return;
        }
        this.wasRead = comment.isRead(this.user);
        if (this.wasRead && this.markAsRead) {
            return;
        }
        boolean isLeftUnread = this.unreadManager.isMarkedLeaveUnread(this.user, comment);
        if (isLeftUnread && !this.markAsRead) {
            return;
        }
        this.frxId = this.getRootFrxId(comment);
        if (this.markAsRead) {
            this.unreadManager.markAsRead(this.user, comment);
        } else {
            this.unreadManager.markAsLeaveUnread(this.user, comment);
        }
        ++this.commentsChanged;
    }

    private String bail(String errorMessage) {
        this.setErrorMsg(errorMessage);
        return "error";
    }
}

