/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.comment;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.crucible.configuration.metrics.MetricsConfig;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.InlineComment;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.LogManager;
import com.google.common.base.Strings;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseCommentAction
extends ReviewBaseAction
implements AjaxResponse {
    protected String newText;
    protected boolean draft = false;
    protected boolean defect = false;
    private String errorMsg = "";
    private Integer commentId;
    protected boolean newComment = false;
    protected boolean wasDraft;
    private boolean worked = true;
    private String oldCommentText;
    @Autowired
    protected CommentManager commentManager;

    public String getPayload() {
        return "Not Used";
    }

    public String getNewText() {
        return this.newText;
    }

    public void setNewText(String newText) {
        this.newText = newText.trim();
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public void setDefect(String[] defect) {
        this.defect = Boolean.valueOf(defect[0]);
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    public boolean isAllowed() {
        return this.isCommentingAllowed();
    }

    protected void setWorked(boolean worked) {
        this.worked = worked;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    protected void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        this.worked = Strings.isNullOrEmpty((String)errorMsg);
    }

    public void setCommentId(Integer commentId) {
        this.commentId = commentId;
    }

    protected Integer getCommentId() {
        return this.commentId;
    }

    protected Comment makeComment() {
        Comment comment;
        if (Strings.isNullOrEmpty((String)this.newText)) {
            this.setErrorMsg("Your comment wasn't added because no text was provided.");
            return null;
        }
        this.newComment = false;
        if (this.commentId == null || this.commentId == -1) {
            comment = this.commentManager.createComment(this.newText, this.getReview(), this.getCurrentUser());
            this.newComment = true;
        } else {
            comment = this.commentManager.getById(this.commentId);
        }
        if (comment == null) {
            if (this.newComment) {
                this.setErrorMsg("There was a problem creating a new comment.");
            } else {
                this.setErrorMsg("There was a problem getting the comment to edit - commentId=" + this.commentId + ".");
            }
            return null;
        }
        if (!this.newComment) {
            if (!comment.getUser().equals(this.getCurrentUser())) {
                this.setErrorMsg("This comment is not yours.");
                return null;
            }
            this.oldCommentText = comment.getMessage();
            this.wasDraft = comment.isDraft();
            if (!this.draft) {
                if (this.wasDraft) {
                    comment.setMessage(this.newText);
                    LogManager.logCommentAdded(this.getReview(), comment);
                } else {
                    LogManager.logCommentChanged(this.getReview(), comment, this.newText);
                }
            }
            comment.setMessage(this.newText);
            comment.setUpdatedDateTime(System.currentTimeMillis());
        } else if (!this.draft) {
            LogManager.logCommentAdded(this.getReview(), comment);
        }
        comment.setDeleted(false);
        comment.setDraft(this.draft);
        comment.setDefectRaised(this.defect);
        if (this.defect) {
            MetricsConfig mc = this.getMetricsConfig();
            if (mc != null && mc.isValid()) {
                this.addFields(comment, mc.getCommentFields());
            }
        } else {
            comment.clearFields();
        }
        return comment;
    }

    protected void emitCommentEvent(Comment comment) {
        if (this.newComment) {
            this.commentManager.announceCommentCreation(comment);
        } else {
            this.commentManager.announceCommentUpdate(comment, this.oldCommentText, this.wasDraft);
        }
    }

    public Integer getRootFrxId(Comment comment) {
        FRXComment frxComment = this.commentManager.findFrxComment(comment);
        InlineComment inlineComment = this.commentManager.findInlineComment(comment);
        if (frxComment != null) {
            return frxComment.getFrx().getId();
        }
        if (inlineComment != null) {
            return inlineComment.getFrx().getId();
        }
        Comment root = comment.getRootComment();
        if (root != null) {
            frxComment = this.commentManager.findFrxComment(root);
            inlineComment = this.commentManager.findInlineComment(root);
            if (frxComment != null) {
                return frxComment.getFrx().getId();
            }
            if (inlineComment != null) {
                return inlineComment.getFrx().getId();
            }
        }
        return null;
    }

    public int getCommentCountDelta() {
        return 0;
    }

    public int getUnreadCommentCountDelta() {
        return 0;
    }

    public Integer getFrxId() {
        return null;
    }
}

