/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.chart;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.reports.Period;
import com.cenqua.crucible.reports.reviews.ReviewChart;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.vis.ChartDimension;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;

public class ReviewsAction
extends BaseAction {
    private int w = 200;
    private int h = 100;
    private Period period = new Period();
    private Project project;
    private String stateName = "Review";

    public ReviewsAction() {
        this.period.lastWeek();
        this.setProject("CR");
    }

    public void setH(int h2) {
        this.h = h2;
    }

    public void setW(int w2) {
        this.w = w2;
    }

    public void setFrom(String from) {
        this.period.setFromStr(from);
    }

    public void setTo(String to) {
        this.period.setToStr(to);
    }

    public void setProject(String projKey) {
        ProjectManager pm = (ProjectManager)SpringContext.getComponent("projectManager");
        this.project = pm.getProjectByKey(projKey);
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        try {
            ReviewChart reviewChart = new ReviewChart();
            this.getResponse().setContentType(reviewChart.getImageContentType());
            ServletOutputStream out = this.getResponse().getOutputStream();
            reviewChart.getRenderChart((OutputStream)out, ChartDimension.restrictDimension(this.w), ChartDimension.restrictDimension(this.h), this.period.getFrom(), this.period.getTo(), this.project, this.stateName);
            return "none";
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)e2.getMessage(), (Throwable)e2);
            return "none";
        }
    }
}

