/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.chart;

import com.atlassian.crucible.actions.chart.BaseSparklineCalculator;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.managers.LogRecordProcessor;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.reports.DistributionSparkLineCreator;
import com.cenqua.crucible.reports.SparkLineCreator;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Date;

public abstract class PerReviewSparklineCalculator
extends BaseSparklineCalculator {
    private LogRecordProcessor processor = new LogRecordProcessor(){
        private static final int NUMBER_OF_BUCKETS = 30;
        private Int2IntMap attributeDistribution = new Int2IntOpenHashMap();
        int currentReviewId = -1;
        boolean includeCurrentReview = false;
        boolean calculationsComplete = false;
        double reviewCount = 0.0;
        double attributeTotal = 0.0;

        @Override
        public void handle(StateChangeLog log) {
            if (log.getReviewId() != this.currentReviewId) {
                this.processReview();
                this.currentReviewId = log.getReviewId();
            }
            if (!this.includeCurrentReview) {
                this.includeCurrentReview = PerReviewSparklineCalculator.this.includeReview(log);
            }
        }

        @Override
        public void afterFinalRecord() {
            this.processReview();
            this.calculationsComplete = true;
        }

        @Override
        public double[] getData() {
            int maxCount = 0;
            IntIterator intIterator = this.attributeDistribution.keySet().iterator();
            while (intIterator.hasNext()) {
                int i2 = (Integer)intIterator.next();
                if (i2 <= maxCount) continue;
                maxCount = i2;
            }
            int bucketFactor = maxCount / 30;
            if (bucketFactor == 0) {
                bucketFactor = 1;
            }
            double[] frequencies = new double[31];
            for (Int2IntMap.Entry e2 : this.attributeDistribution.int2IntEntrySet()) {
                int key = e2.getIntValue();
                int index = key / bucketFactor;
                if (index > 29) {
                    index = 29;
                }
                int n2 = index;
                frequencies[n2] = frequencies[n2] + (double)e2.getIntValue();
            }
            return frequencies;
        }

        @Override
        public double getSummary() {
            return this.reviewCount == 0.0 ? 0.0 : this.attributeTotal / this.reviewCount;
        }

        @Override
        public boolean calculationsComplete() {
            return this.calculationsComplete;
        }

        private void processReview() {
            if (this.currentReviewId != -1 && this.includeCurrentReview) {
                int attributeValue = PerReviewSparklineCalculator.this.getReviewAttribute(PerReviewSparklineCalculator.this.reviewManager.getReviewById(this.currentReviewId));
                this.attributeDistribution.put(attributeValue, this.attributeDistribution.get(attributeValue) + 1);
                this.reviewCount += 1.0;
                this.attributeTotal += (double)attributeValue;
                this.includeCurrentReview = false;
            }
        }
    };
    private final ReviewManager reviewManager;

    protected abstract boolean includeReview(StateChangeLog var1);

    protected abstract int getReviewAttribute(Review var1);

    public PerReviewSparklineCalculator(Date from, Date to, ReviewManager reviewManager) {
        super(from, to);
        this.reviewManager = reviewManager;
    }

    @Override
    protected SparkLineCreator getCreator() {
        return new DistributionSparkLineCreator();
    }

    @Override
    public LogRecordProcessor getLogRecordProcessor() {
        return this.processor;
    }
}

