/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.chart;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.crucible.actions.search.comment.CommentSearchData;
import com.atlassian.xwork.ParameterSafe;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.reports.PieChart;
import com.cenqua.crucible.reports.PieDatasetAdjuster;
import com.cenqua.crucible.reports.commentsDefects.DefectRepDatasetMaker;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.vis.ChartDimension;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.jfree.data.general.DefaultPieDataset;
import org.springframework.beans.factory.annotation.Autowired;

public class DefectRepAction
extends BaseAction {
    private int w = 200;
    private int h = 100;
    private Project project;
    private String metric;
    private int maxSegments = 0;
    private CommentSearchData sd;
    private CommentManager commentManager;

    @Autowired
    public void setCommentManager(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    @Override
    @Autowired
    public void setReviewManager(ReviewManager reviewManager) {
        this.reviewManager = reviewManager;
        this.sd = new CommentSearchData(reviewManager);
    }

    public void setH(int h2) {
        this.h = h2;
    }

    public void setW(int w2) {
        this.w = w2;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setTo(String to) {
        this.sd.getPeriod().setToStr(to);
    }

    public void setFrom(String from) {
        this.sd.getPeriod().setFromStr(from);
    }

    public void setProject(String projKey) {
        this.project = this.projectManager.getProjectByKey(projKey);
        this.sd.setProjectId(this.project.getId());
    }

    @ParameterSafe
    public CommentSearchData getSearch() {
        return this.sd;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        try {
            DefectRepDatasetMaker dataSetMaker = new DefectRepDatasetMaker(this.commentManager, this.sd, this.metric);
            PieChart defectRepChart = new PieChart();
            this.getResponse().setContentType(defectRepChart.getImageContentType());
            ServletOutputStream out = this.getResponse().getOutputStream();
            DefaultPieDataset dataSet = PieDatasetAdjuster.addPercentToLabels(PieDatasetAdjuster.adjustPieDataset(dataSetMaker.getPieDataSet(), this.maxSegments, 2.0));
            defectRepChart.renderChart((OutputStream)out, ChartDimension.restrictDimension(this.w), ChartDimension.restrictDimension(this.h), defectRepChart.createChart("", dataSet, true));
            return "none";
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)e2.getMessage(), (Throwable)e2);
            return "none";
        }
    }

    public void setMaxSegments(int maxSegments) {
        this.maxSegments = maxSegments;
    }
}

