/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.chart;

import com.atlassian.crucible.actions.chart.BaseSparklineCalculator;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.managers.LogRecordProcessor;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.reports.DistributionSparkLineCreator;
import com.cenqua.crucible.reports.SparkLineCreator;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class DaysToCompleteSparklineCalculator
extends BaseSparklineCalculator {
    private LogRecordProcessor processor = new LogRecordProcessor(){
        final int measurementRange;
        public final double[] completionTimes;
        int currentReviewId;
        int currentReviewOpenDayIndex;
        int currentReviewCloseDayIndex;
        final Set<String> stateSet;
        boolean calculationsComplete;
        double reviewCount;
        double totalDaysSpent;
        {
            this.measurementRange = (int)((DaysToCompleteSparklineCalculator.this.getToDate().getTime() - DaysToCompleteSparklineCalculator.this.getFromDate().getTime()) / 86400000L);
            this.completionTimes = new double[this.measurementRange + 1];
            this.currentReviewId = -1;
            this.currentReviewOpenDayIndex = -1;
            this.currentReviewCloseDayIndex = -1;
            this.stateSet = new HashSet<String>(Arrays.asList(StateManager.INSTANCE.getOpenStateNames()));
            this.calculationsComplete = false;
            this.reviewCount = 0.0;
            this.totalDaysSpent = 0.0;
        }

        @Override
        public void handle(StateChangeLog log) {
            if (log.getReviewId() != this.currentReviewId) {
                this.processReview();
                this.currentReviewId = log.getReviewId();
            }
            int day = DaysToCompleteSparklineCalculator.this.dayIndex(DaysToCompleteSparklineCalculator.this.getFromDate(), log.getTimeStamp());
            if (this.currentReviewOpenDayIndex == -1 && this.stateSet.contains(log.getNewState())) {
                this.currentReviewOpenDayIndex = day;
            }
            if (this.currentReviewCloseDayIndex == -1 && !this.stateSet.contains(log.getNewState())) {
                this.currentReviewCloseDayIndex = day;
            }
        }

        @Override
        public void afterFinalRecord() {
            this.processReview();
            this.calculationsComplete = true;
        }

        @Override
        public double[] getData() {
            return this.completionTimes;
        }

        @Override
        public double getSummary() {
            return this.reviewCount == 0.0 ? 0.0 : this.totalDaysSpent / this.reviewCount;
        }

        @Override
        public boolean calculationsComplete() {
            return this.calculationsComplete;
        }

        public void processReview() {
            if (this.currentReviewOpenDayIndex != -1 && this.currentReviewCloseDayIndex != -1 && this.currentReviewCloseDayIndex <= 30) {
                int openDays = this.currentReviewCloseDayIndex - this.currentReviewOpenDayIndex;
                if (openDays < 0) {
                    openDays = 0;
                }
                if (openDays > this.measurementRange) {
                    openDays = this.measurementRange;
                }
                int n2 = openDays;
                this.completionTimes[n2] = this.completionTimes[n2] + 1.0;
                this.reviewCount += 1.0;
                this.totalDaysSpent += (double)openDays;
            }
            this.currentReviewOpenDayIndex = -1;
            this.currentReviewCloseDayIndex = -1;
        }
    };

    public DaysToCompleteSparklineCalculator(Date from, Date to) {
        super(from, to);
    }

    @Override
    protected SparkLineCreator getCreator() {
        return new DistributionSparkLineCreator();
    }

    @Override
    public LogRecordProcessor getLogRecordProcessor() {
        return this.processor;
    }
}

