/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.chart;

import com.atlassian.crucible.actions.chart.PerReviewSparklineCalculator;
import com.atlassian.crucible.actions.search.comment.CommentSearchData;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import java.util.Date;

public class CommentsPerReviewSparklineCalculator
extends PerReviewSparklineCalculator {
    private final String reviewStateName = StateManager.INSTANCE.getReviewState().getName();
    private final CommentManager commentManager;

    public CommentsPerReviewSparklineCalculator(Date from, Date to, CommentManager commentManager) {
        super(from, to, DefaultReviewManager.get());
        this.commentManager = commentManager;
    }

    @Override
    protected boolean includeReview(StateChangeLog log) {
        int day = this.dayIndex(this.getFromDate(), log.getTimeStamp());
        return day > 0 && log.getNewState().equals(this.reviewStateName);
    }

    @Override
    protected int getReviewAttribute(Review review) {
        CommentSearchData search = new CommentSearchData(DefaultReviewManager.get());
        search.setReview(review);
        Long count = this.commentManager.countComments(search);
        return count.intValue();
    }
}

