/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.chart;

import com.atlassian.crucible.actions.chart.SparkLineCalculator;
import com.cenqua.crucible.reports.SparkLineCreator;
import com.cenqua.crucible.reports.SparkLineResult;
import java.awt.image.BufferedImage;
import java.util.Date;
import org.jfree.chart.JFreeChart;

public abstract class BaseSparklineCalculator
implements SparkLineCalculator {
    private Date to;
    private Date from;
    protected static final long MILLISECONDS_PER_DAY = 86400000L;

    public BaseSparklineCalculator(Date from, Date to) {
        this.from = from;
        this.to = to;
    }

    @Override
    public SparkLineResult getResult() {
        if (!this.getLogRecordProcessor().calculationsComplete()) {
            throw new RuntimeException("Called getResult() before providing log records to LogRecordProcessor()");
        }
        JFreeChart chart = this.getCreator().create(this.getLogRecordProcessor().getData());
        BufferedImage image = chart.createBufferedImage(this.getWidth(), this.getHeight());
        return new SparkLineResult(image, this.getLogRecordProcessor().getSummary());
    }

    protected int getHeight() {
        return 25;
    }

    protected int getWidth() {
        return 100;
    }

    protected Date getFromDate() {
        return this.from;
    }

    protected Date getToDate() {
        return this.to;
    }

    protected abstract SparkLineCreator getCreator();

    protected int dayIndex(Date from, Date timeStamp) {
        return (int)((timeStamp.getTime() - from.getTime()) / 86400000L);
    }
}

