/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.chart;

import com.atlassian.crucible.actions.chart.SparkLineCalculator;
import com.atlassian.crucible.actions.project.BaseProjectAction;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.reports.SparkLineResultCache;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.DateHelper;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import org.jfree.chart.ChartUtilities;

public abstract class BaseSparklineAction
extends BaseProjectAction {
    private Date to;
    private Date from;
    private SparkLineResultCache sparkLineResultCache;

    protected BaseSparklineAction() {
        Calendar cal = DateHelper.getStartOfTodayAsCalendar(AppConfig.getsConfig().getTimezone());
        cal.add(6, 1);
        this.to = cal.getTime();
        cal.add(2, -1);
        this.from = cal.getTime();
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        try {
            this.getResponse().setContentType("image/png");
            ServletOutputStream out = this.getResponse().getOutputStream();
            if (out != null) {
                ChartUtilities.writeBufferedImageAsPNG((OutputStream)out, (BufferedImage)this.sparkLineResultCache.get(this.getProject(), this.from, this.to, this.getSparkLineCalculator()).getChart());
            }
            return "none";
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Error executing action", (Throwable)e2);
            return "none";
        }
    }

    protected int getHeight() {
        return 25;
    }

    protected int getWidth() {
        return 100;
    }

    protected Date getFromDate() {
        return this.from;
    }

    protected Date getToDate() {
        return this.to;
    }

    protected abstract SparkLineCalculator getSparkLineCalculator();

    public void setSparkLineResultCache(SparkLineResultCache sparkLineResultCache) {
        this.sparkLineResultCache = sparkLineResultCache;
    }
}

