/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.project.data;

import com.atlassian.crucible.actions.admin.project.UserData;
import com.atlassian.crucible.actions.admin.project.data.ProjectData;
import com.atlassian.crucible.actions.admin.project.data.ProjectDataFactory;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectKeyException;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.model.ContentRoot;
import com.cenqua.fisheye.syntax.LinkerFactory;
import com.cenqua.fisheye.user.UserManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="projectDataFactory")
public class ProjectDataFactoryImpl
implements ProjectDataFactory {
    private final LinkerFactory linkerFactory;
    private final SPIUserUtils spiUserUtils;
    private final PermissionManager permissionManager;

    @Autowired
    public ProjectDataFactoryImpl(LinkerFactory linkerFactory, SPIUserUtils spiUtils, PermissionManager permissionManager) {
        this.linkerFactory = linkerFactory;
        this.spiUserUtils = spiUtils;
        this.permissionManager = permissionManager;
    }

    @Override
    public ProjectData createFromProject(Project p2) {
        return new ProjectData(p2);
    }

    @Override
    public void updateProject(ProjectManager projectManager, ProjectData projectData) throws ProjectKeyException {
        if (projectData.getId() < 1) {
            throw new IllegalArgumentException("ID must be a positive integer.");
        }
        Project p2 = projectManager.getProjectById(projectData.getId());
        if (p2 == null) {
            throw new IllegalArgumentException("Project " + projectData.getId() + " does not exist.");
        }
        if (!p2.getProjKey().equals(projectData.getKey())) {
            if (projectManager.getProjectByKey(projectData.getKey()) != null) {
                throw new ProjectKeyException();
            }
            projectManager.changeProjectKey(p2, projectData.getKey());
        }
        p2.setAllowReviewersToJoin(projectData.isAllowReviewersToJoin());
        p2.setStoreRevisions(projectData.isStoreRevisions());
        UserData defaultModerator = projectData.getDefaultModerator();
        if (defaultModerator != null) {
            p2.setDefaultModerator(this.spiUserUtils.getUserByName(defaultModerator.getUsername()));
        } else {
            p2.setDefaultModerator(null);
        }
        p2.setDefaultRepositoryName(projectData.getDefaultRepositoryName());
        p2.setDefaultReviewerUsers(this.userDataCollectionToCrucibleUserSet(projectData.getDefaultReviewerUsers()));
        p2.setDefaultReviewerGroups(this.normaliseGroupNames(projectData.getDefaultReviewerGroups()));
        p2.setAllowedReviewerUsers(this.userDataCollectionToCrucibleUserSet(projectData.getAllowedReviewerUsers()));
        p2.setAllowedReviewerGroups(this.normaliseGroupNames(projectData.getAllowedReviewerGroups()));
        p2.setProjKey(projectData.getKey());
        p2.setName(projectData.getName());
        p2.setPermissionScheme(this.permissionManager.findPermissionSchemeById(projectData.getPermissionSchemeId()));
        p2.setSuggestedReviewerConfig(projectData.getSuggestedReviewerConfig());
        p2.setDefaultDuration(projectData.getDefaultDuration());
        p2.setContentRoots(new HashSet<ContentRoot>(projectData.getContentRoots()));
        p2.setDefaultObjectives(projectData.getDefaultObjectives());
        p2.setModeratorDisabled(projectData.isModeratorDisabled());
        this.linkerFactory.clearCrucibleLinkerCache();
    }

    private Set<String> normaliseGroupNames(Collection<String> groups) {
        return groups == null ? null : groups.stream().map(UserManager.GROUPNAME_NORMALIZATION).collect(Collectors.toSet());
    }

    private Set<FecruUser> userDataCollectionToCrucibleUserSet(Collection<UserData> userData) {
        HashSet<FecruUser> users = new HashSet<FecruUser>();
        if (userData != null) {
            for (UserData d2 : userData) {
                users.add(this.spiUserUtils.getUserByName(d2.getUsername()));
            }
        }
        return users;
    }
}

