/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.project.data;

import com.atlassian.crucible.actions.admin.project.UserData;
import com.atlassian.crucible.actions.admin.project.data.ProjectDataUtils;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.SuggestedReviewerConfig;
import com.cenqua.fisheye.model.ContentRoot;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ProjectData {
    private int id;
    private String name;
    private String key;
    private Set<UserData> defaultReviewerUsers = Collections.emptySet();
    private Set<UserData> allowedReviewerUsers = Collections.emptySet();
    private Set<String> defaultReviewerGroups;
    private Set<String> allowedReviewerGroups;
    private UserData defaultModerator;
    private String defaultRepositoryName;
    private Integer permissionSchemeId;
    private boolean allowReviewersToJoin;
    private boolean storeRevisions;
    private SuggestedReviewerConfig suggestedReviewerConfig = new SuggestedReviewerConfig();
    private Integer defaultDuration;
    private Set<ContentRoot> contentRoots = new HashSet<ContentRoot>();
    private String defaultObjectives;
    private boolean moderatorEnabled;

    public ProjectData() {
    }

    public ProjectData(Project p2) {
        this.id = p2.getId() == null ? 0 : p2.getId();
        this.setName(p2.getName());
        this.setKey(p2.getProjKey());
        this.defaultReviewerUsers = ProjectDataUtils.crucibleUsersToUserDataSet(p2.getDefaultReviewerUsers());
        this.defaultReviewerGroups = new HashSet<String>(p2.getDefaultReviewerGroups());
        this.allowedReviewerUsers = ProjectDataUtils.crucibleUsersToUserDataSet(p2.getAllowedReviewerUsers());
        this.allowedReviewerGroups = new HashSet<String>(p2.getAllowedReviewerGroups());
        this.defaultModerator = ProjectDataUtils.crucibleUserToUserData(p2.getDefaultModerator());
        this.defaultRepositoryName = p2.getDefaultRepositoryName();
        this.permissionSchemeId = p2.getPermissionScheme() == null ? null : p2.getPermissionScheme().getId();
        this.allowReviewersToJoin = p2.isAllowReviewersToJoin();
        this.storeRevisions = p2.isStoreRevisions();
        this.suggestedReviewerConfig = p2.getSuggestedReviewerConfig();
        this.defaultDuration = p2.getDefaultDuration();
        this.contentRoots = p2.getContentRoots();
        this.defaultObjectives = p2.getDefaultObjectives();
        this.moderatorEnabled = p2.isModeratorEnabled();
    }

    public String getDefaultObjectives() {
        return Strings.isNullOrEmpty((String)this.defaultObjectives) ? this.defaultObjectives : this.defaultObjectives + "\n";
    }

    public void setDefaultObjectives(String defaultObjectives) {
        this.defaultObjectives = defaultObjectives;
    }

    public void setName(String name) {
        this.name = StringUtils.trim((String)name);
    }

    public void setKey(String key) {
        this.key = StringUtils.trim((String)key);
    }

    public SuggestedReviewerConfig getSuggestedReviewerConfig() {
        return this.suggestedReviewerConfig;
    }

    public void setSuggestedReviewerConfig(SuggestedReviewerConfig suggestedReviewerConfig) {
        this.suggestedReviewerConfig = suggestedReviewerConfig;
    }

    public void setDefaultModerator(UserData defaultModerator) {
        this.defaultModerator = defaultModerator;
    }

    public void setDefaultRepositoryName(String defaultRepositoryName) {
        this.defaultRepositoryName = defaultRepositoryName;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public UserData getDefaultModerator() {
        return this.defaultModerator;
    }

    public String getDefaultRepositoryName() {
        return this.defaultRepositoryName;
    }

    public Integer getDefaultDuration() {
        return this.defaultDuration;
    }

    public void setDefaultDuration(Integer defaultDuration) {
        this.defaultDuration = defaultDuration;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public Integer getPermissionSchemeId() {
        return this.permissionSchemeId;
    }

    public void setPermissionSchemeId(Integer permissionSchemeId) {
        this.permissionSchemeId = permissionSchemeId;
    }

    public boolean isAllowReviewersToJoin() {
        return this.allowReviewersToJoin;
    }

    public void setAllowReviewersToJoin(boolean allowReviewersToJoin) {
        this.allowReviewersToJoin = allowReviewersToJoin;
    }

    public Set<UserData> getDefaultReviewerUsers() {
        return this.defaultReviewerUsers;
    }

    public void setDefaultReviewerUsers(Set<UserData> defaultReviewerUsers) {
        this.defaultReviewerUsers = defaultReviewerUsers;
    }

    public Set<UserData> getAllowedReviewerUsers() {
        return this.allowedReviewerUsers;
    }

    public void setAllowedReviewerUsers(Set<UserData> allowedReviewerUsers) {
        this.allowedReviewerUsers = allowedReviewerUsers;
    }

    public Set<String> getDefaultReviewerGroups() {
        return this.defaultReviewerGroups;
    }

    public void setDefaultReviewerGroups(Set<String> defaultReviewerGroups) {
        this.defaultReviewerGroups = defaultReviewerGroups;
    }

    public Set<String> getAllowedReviewerGroups() {
        return this.allowedReviewerGroups;
    }

    public void setAllowedReviewerGroups(Set<String> allowedReviewerGroups) {
        this.allowedReviewerGroups = allowedReviewerGroups;
    }

    public boolean isStoreRevisions() {
        return this.storeRevisions;
    }

    public void setStoreRevisions(boolean storeRevisions) {
        this.storeRevisions = storeRevisions;
    }

    public boolean isModeratorDisabled() {
        return !this.isModeratorEnabled();
    }

    public boolean isModeratorEnabled() {
        return this.moderatorEnabled;
    }

    public void setModeratorEnabled(boolean moderatorEnabled) {
        this.moderatorEnabled = moderatorEnabled;
    }

    public String getDefaultReviewerUsersAsString() {
        return Joiner.on((String)", ").join(this.getDefaultReviewerUsers());
    }

    public String getDefaultReviewerGroupsAsString() {
        return Joiner.on((String)", ").join(this.getDefaultReviewerGroups());
    }

    public Set<ContentRoot> getContentRoots() {
        return this.contentRoots;
    }

    public void setContentRoots(Set<ContentRoot> contentRoots) {
        this.contentRoots = contentRoots;
    }
}

