/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.project;

import com.atlassian.crucible.actions.admin.project.AbstractModifyProjectFormAction;
import com.atlassian.crucible.actions.admin.project.data.ProjectData;
import com.atlassian.crucible.actions.admin.project.data.ProjectDataFactory;
import com.atlassian.crucible.spi.TxCallback;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ProjectKeyException;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.transaction.TransactionStatus;

public class UpdateProjectAction
extends AbstractModifyProjectFormAction {
    private ProjectDataFactory projectDataFactory;
    private static final Pattern PROJECT_KEY_PATTERN = Pattern.compile("([A-Z0-9\\-]+)");

    public String execute() throws Exception {
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                int id = UpdateProjectAction.this.getProjectId();
                Matcher m2 = PROJECT_KEY_PATTERN.matcher(UpdateProjectAction.this.getProjectKey());
                if (!m2.matches()) {
                    UpdateProjectAction.this.addActionError("Invalid project key, only alphanumeric and uppercase values are allowed.");
                    return "error";
                }
                if (Strings.isNullOrEmpty((String)UpdateProjectAction.this.getProjectName())) {
                    UpdateProjectAction.this.addActionError("Project name can't be blank.");
                    return "error";
                }
                if (id < 1) {
                    Project p2 = UpdateProjectAction.this.projectManager.getProjectByKey(UpdateProjectAction.this.getProjectKey());
                    if (p2 != null) {
                        UpdateProjectAction.this.addActionError("Could not create a new project with an existing project key.");
                        return "error";
                    }
                    p2 = UpdateProjectAction.this.createNewProject(UpdateProjectAction.this.getProjectData());
                    UpdateProjectAction.this.getProjectData().setId(p2.getId());
                } else {
                    try {
                        UpdateProjectAction.this.projectDataFactory.updateProject(UpdateProjectAction.this.projectManager, UpdateProjectAction.this.getProjectData());
                    }
                    catch (ProjectKeyException e2) {
                        UpdateProjectAction.this.addActionError("Could not update project, the key is being used by another project.");
                        return "error";
                    }
                }
                return "success";
            }
        });
    }

    private Project createNewProject(ProjectData projectData) throws IOException {
        Project p2 = this.projectManager.createProject(this.getProjectName(), this.getProjectKey());
        projectData.setId(p2.getId());
        if (null == projectData.getPermissionSchemeId()) {
            projectData.setPermissionSchemeId(p2.getPermissionScheme().getId());
        }
        this.projectDataFactory.updateProject(this.projectManager, projectData);
        return p2;
    }

    public void setProjectDataFactory(ProjectDataFactory projectDataFactory) {
        this.projectDataFactory = projectDataFactory;
    }
}

