/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.project;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.crucible.spi.data.ProjectData;
import com.atlassian.crucible.spi.services.ProjectSearchCriteria;
import com.atlassian.crucible.spi.services.ProjectService;
import com.atlassian.crucible.spi.services.SearchCriteriaJunctionType;
import com.atlassian.crucible.spi.services.SearchCriteriaType;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.web.paging.PagingCalculator;
import com.cenqua.fisheye.web.paging.TotalCountAwarePagingCalculator;
import com.google.common.collect.Lists;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ListProjectsAction
extends BaseAction {
    @Autowired
    private ProjectService projectService;
    private Iterable<ListProjectDO> projects;
    private PagingCalculator pagingCalculator;

    private void initProjectData() {
        String filterString = this.getParameter("filterString");
        ProjectSearchCriteria projectSearchCriteria = ListProjectsAction.createProjectSearchCriteriaForFilterString(filterString);
        int projectCount = this.projectService.countProjects(projectSearchCriteria);
        this.pagingCalculator = TotalCountAwarePagingCalculator.getPagingCalculator(this.getRequest(), projectCount);
        PageRequest pageRequest = this.pagingCalculator.createPageRequest();
        Page projectDataPage = this.projectService.searchProjects(projectSearchCriteria, pageRequest);
        Page listProjectDOPage = projectDataPage.transform(projectData -> {
            PermissionScheme permissionScheme = this.permissionManager.findPermissionSchemeByName(projectData.getPermissionSchemeName());
            return new ListProjectDO((ProjectData)projectData, permissionScheme);
        });
        this.projects = Lists.newArrayList((Iterable)listProjectDOPage.getValues());
    }

    public Iterable<ListProjectDO> getProjects() {
        if (this.projects == null) {
            this.initProjectData();
        }
        return this.projects;
    }

    private static ProjectSearchCriteria createProjectSearchCriteriaForFilterString(@Nullable String keyOrNameOrPermissionSchemePartial) {
        if (keyOrNameOrPermissionSchemePartial == null) {
            return ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).all();
        }
        ProjectSearchCriteria projectSearchCriteria = ProjectSearchCriteria.create((SearchCriteriaJunctionType)SearchCriteriaJunctionType.OR, (SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        projectSearchCriteria.key = keyOrNameOrPermissionSchemePartial;
        projectSearchCriteria.name = keyOrNameOrPermissionSchemePartial;
        if (AppConfig.isCrucible()) {
            projectSearchCriteria.permissionSchemeName = keyOrNameOrPermissionSchemePartial;
        }
        return projectSearchCriteria;
    }

    public PagingCalculator getPagingCalculator() {
        if (this.pagingCalculator == null) {
            this.initProjectData();
        }
        return this.pagingCalculator;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        return super.execute();
    }

    public static class ListProjectDO {
        private final PermissionScheme permissionScheme;
        private final ProjectData data;
        private boolean hasModeratorConflicts;

        public ListProjectDO(ProjectData data, PermissionScheme permissionScheme) {
            this.data = data;
            this.permissionScheme = permissionScheme;
            this.hasModeratorConflicts = AppConfig.isCrucible() && !data.isModeratorEnabled() && permissionScheme.getRequiresModerator();
        }

        public PermissionScheme getPermissionScheme() {
            return this.permissionScheme;
        }

        public ProjectData getData() {
            return this.data;
        }

        public boolean isHasModeratorConflicts() {
            return this.hasModeratorConflicts;
        }
    }
}

