/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.project;

import com.atlassian.crucible.actions.admin.project.AbstractProjectFormAction;
import com.cenqua.crucible.model.Project;

public class DeleteProjectAction
extends AbstractProjectFormAction {
    private String deleteAction = null;
    private Integer moveToProjectId = null;

    public void setDeleteAction(String deleteAction) {
        this.deleteAction = deleteAction;
    }

    public void setMoveToProjectId(int moveToProjectId) {
        this.moveToProjectId = moveToProjectId;
    }

    public String execute() throws Exception {
        if (this.id == null) {
            this.addActionError("No project selected to delete.");
            return "list";
        }
        Project p2 = this.getProject(this.id);
        if (p2 == null) {
            this.addActionError("Project with id " + this.id + " not found.");
            return "list";
        }
        if (this.deleteAction == null) {
            if (this.projectManager.getDefaultProject().equals(p2)) {
                this.addActionError("Default Project can't be deleted.");
                return "list";
            }
            if (this.projectManager.deleteProject(p2)) {
                return "list";
            }
            return "deleteOptions";
        }
        return this.doDeleteAction(p2);
    }

    private String doDeleteAction(Project p2) {
        if ("deleteReviews".equals(this.deleteAction)) {
            this.projectManager.deleteAllReviews(p2, this.getCurrentUser(), this.reviewManager);
            this.projectManager.deleteProject(p2);
            return "list";
        }
        if ("moveReviews".equals(this.deleteAction)) {
            Project newProject = this.getProject(this.moveToProjectId);
            if (newProject == null) {
                this.addActionError("Can't move to Project, id " + this.moveToProjectId + " not found.");
                return "deleteOptions";
            }
            this.projectManager.moveAllReviews(p2, newProject);
            this.projectManager.deleteProject(p2);
            return "list";
        }
        this.addActionError("You must choose an action.");
        return "deleteOptions";
    }
}

