/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.project;

import com.atlassian.crucible.actions.admin.project.BaseProjectAction;
import com.atlassian.crucible.scm.SCMRepository;
import com.atlassian.fecru.page.OnePageRequest;
import com.atlassian.fecru.page.Page;
import com.atlassian.fisheye.scm.SCMModuleManager;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.user.GroupInfo;
import com.cenqua.fisheye.user.GroupSearchCriteria;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Resource;

public abstract class AbstractProjectFormAction
extends BaseProjectAction {
    @Resource
    private RepositoryManager repositoryManager;
    @Resource
    private SCMModuleManager scmModuleManager;
    private List<PermissionScheme> permissionSchemes;

    public Map<Integer, String> getAllPermissionSchemeMap() {
        HashMap<Integer, String> permSchemeMap = new HashMap<Integer, String>();
        for (PermissionScheme permissionScheme : this.getAllPermissionSchemes()) {
            permSchemeMap.put(permissionScheme.getId(), permissionScheme.getName());
        }
        return permSchemeMap;
    }

    public List<PermissionScheme> getAllPermissionSchemes() {
        if (this.permissionSchemes == null) {
            this.permissionSchemes = new ArrayList<PermissionScheme>();
            Iterables.addAll(this.permissionSchemes, this.permissionManager.getPermissionSchemes());
        }
        return this.permissionSchemes;
    }

    public Collection<String> getAllRepositoryNames() {
        ArrayList<String> repoData = new ArrayList<String>();
        repoData.addAll(this.repositoryManager.getHandleMap().keySet());
        for (SCMRepository r2 : this.scmModuleManager.getRepositories()) {
            repoData.add(r2.getName());
        }
        return repoData;
    }

    public Collection<String> getAllGroups() {
        Page<GroupInfo> allGroups = this.userManager.searchGroups(GroupSearchCriteria.create(), OnePageRequest.createNoLimit());
        return StreamSupport.stream(allGroups.getValues().spliterator(), false).map(GroupInfo::getName).map(UserManager.GROUPNAME_NORMALIZATION).collect(Collectors.toList());
    }
}

