/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.project;

import com.atlassian.crucible.actions.admin.project.AbstractProjectFormAction;
import com.atlassian.crucible.actions.admin.project.UserData;
import com.atlassian.crucible.actions.admin.project.data.ProjectData;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Project;
import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractModifyProjectFormAction
extends AbstractProjectFormAction {
    private ProjectData projectData = new ProjectData();

    ProjectData getProjectData() {
        return this.projectData;
    }

    void setProjectData(ProjectData projectData) {
        this.projectData = projectData;
    }

    public int getProjectId() {
        return this.getProjectData().getId();
    }

    public void setProjectId(int projectId) {
        this.getProjectData().setId(projectId);
    }

    public Integer getPermissionSchemeId() {
        return this.getProjectData().getPermissionSchemeId();
    }

    public void setPermissionSchemeId(Integer permissionSchemeId) {
        this.getProjectData().setPermissionSchemeId(permissionSchemeId);
    }

    public String getProjectName() {
        return this.getProjectData().getName();
    }

    public void setProjectName(String projectName) {
        this.getProjectData().setName(projectName);
    }

    public String getProjectKey() {
        return this.getProjectData().getKey();
    }

    public void setProjectKey(String projectKeyMixedCase) {
        String projectKey = Project.upperCaseProjectKey(projectKeyMixedCase);
        this.getProjectData().setKey(projectKey);
    }

    public String getDefaultRepositoryName() {
        return this.getProjectData().getDefaultRepositoryName();
    }

    public void setDefaultRepositoryName(String defaultRepositoryName) {
        this.getProjectData().setDefaultRepositoryName(defaultRepositoryName);
    }

    public boolean isStoreRevisions() {
        return this.getProjectData().isStoreRevisions();
    }

    public void setStoreRevisions(boolean storeRevisions) {
        this.getProjectData().setStoreRevisions(storeRevisions);
    }

    public boolean isModeratorEnabled() {
        return this.getProjectData().isModeratorEnabled();
    }

    public void setModeratorEnabled(boolean moderatorEnabled) {
        this.getProjectData().setModeratorEnabled(moderatorEnabled);
    }

    public Set<UserData> getDefaultReviewerUsers() {
        return this.getProjectData().getDefaultReviewerUsers();
    }

    public void setDefaultReviewerUsers(String defaultReviewers) {
        this.getProjectData().setDefaultReviewerUsers(this.convertStringToUserDataSet(defaultReviewers));
    }

    public Set<UserData> getAllowedReviewerUsers() {
        return this.getProjectData().getAllowedReviewerUsers();
    }

    public void setAllowedReviewerUsers(String allowedReviewers) {
        this.getProjectData().setAllowedReviewerUsers(this.convertStringToUserDataSet(allowedReviewers));
    }

    public Set<String> getDefaultReviewerGroups() {
        return this.getProjectData().getDefaultReviewerGroups();
    }

    public void setDefaultReviewerGroups(String defaultReviewers) {
        this.getProjectData().setDefaultReviewerGroups(this.convertStringToStringSet(defaultReviewers));
    }

    public Set<String> getAllowedReviewerGroups() {
        return this.getProjectData().getAllowedReviewerGroups();
    }

    public void setAllowedReviewerGroups(String allowedReviewers) {
        this.getProjectData().setAllowedReviewerGroups(this.convertStringToStringSet(allowedReviewers));
    }

    public Integer getDefaultDuration() {
        return this.getProjectData().getDefaultDuration();
    }

    public void setDefaultDuration(Integer defaultDuration) {
        this.getProjectData().setDefaultDuration(defaultDuration);
    }

    public String getDefaultObjectives() {
        return this.getProjectData().getDefaultObjectives();
    }

    public void setDefaultObjectives(String defaultObjectives) {
        this.getProjectData().setDefaultObjectives(defaultObjectives);
    }

    public UserData getDefaultModerator() {
        return this.getProjectData().getDefaultModerator();
    }

    public void setDefaultModerator(String defaultModerator) {
        FecruUser user;
        if (!Strings.isNullOrEmpty((String)defaultModerator) && (user = this.userManager.getLicensedUser(defaultModerator)) != null) {
            this.getProjectData().setDefaultModerator(this.convertUserToUserData(user));
        }
    }

    public boolean isAllowReviewersToJoin() {
        return this.getProjectData().isAllowReviewersToJoin();
    }

    public void setAllowReviewersToJoin(boolean allowReviewersToJoin) {
        this.getProjectData().setAllowReviewersToJoin(allowReviewersToJoin);
    }

    private Set<String> convertStringToStringSet(String names) {
        HashSet<String> s2 = new HashSet<String>();
        if (names != null) {
            String[] reviewerNames;
            for (String n2 : reviewerNames = names.split(",")) {
                s2.add(n2.trim());
            }
        }
        return s2;
    }

    private Set<UserData> convertStringToUserDataSet(String names) {
        HashSet<UserData> s2 = new HashSet<UserData>();
        if (names != null) {
            String[] reviewerNames;
            for (String n2 : reviewerNames = names.split(",")) {
                FecruUser user;
                if (n2.startsWith(" ")) {
                    n2 = n2.substring(1);
                }
                if ((user = this.userManager.getLicensedUser(n2)) == null) continue;
                s2.add(this.convertUserToUserData(user));
            }
        }
        return s2;
    }

    private UserData convertUserToUserData(FecruUser user) {
        return new UserData(user.getId(), user.getUsername(), user.getDisplayName());
    }
}

