/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.permschemes;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.crucible.spi.TxCallback;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.managers.PermissionManager;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.transaction.TransactionStatus;

public class UpdatePSActionAction
extends BaseAction {
    @Resource
    private PermissionManager permissionManager;
    private Integer psId;
    private String action;
    private boolean anonymousUsers;
    private boolean allUsers;
    private Set<String> actionUsers;
    private Set<String> groups;
    private Set<String> roles;

    public void setPsId(Integer psId) {
        this.psId = psId;
    }

    public Integer getPsId() {
        return this.psId;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setAnonymousUsers(boolean b2) {
        this.anonymousUsers = true;
    }

    public void setAllUsers(boolean b2) {
        this.allUsers = true;
    }

    public void setActionUsers(Set<String> actionUsers) {
        this.actionUsers = actionUsers;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public String execute() throws Exception {
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                PermissionScheme ps = UpdatePSActionAction.this.permissionManager.findPermissionSchemeById(UpdatePSActionAction.this.psId);
                if (ps == null) {
                    UpdatePSActionAction.this.addActionError("Could not find Permission Scheme.");
                    return "error";
                }
                ps.removeAllUsersAction(UpdatePSActionAction.this.action);
                if (UpdatePSActionAction.this.allUsers) {
                    ps.addAllUsersAction(UpdatePSActionAction.this.action);
                }
                ps.removeAnonAction(UpdatePSActionAction.this.action);
                if (UpdatePSActionAction.this.anonymousUsers) {
                    ps.addAnonAction(UpdatePSActionAction.this.action);
                }
                ps.clearUserAction(UpdatePSActionAction.this.action);
                if (UpdatePSActionAction.this.actionUsers != null) {
                    for (String userName : UpdatePSActionAction.this.actionUsers) {
                        ps.addUserAction(userName, UpdatePSActionAction.this.action);
                    }
                }
                ps.clearGroupAction(UpdatePSActionAction.this.action);
                if (UpdatePSActionAction.this.groups != null) {
                    for (String groupName : UpdatePSActionAction.this.groups) {
                        ps.addGroupAction(groupName, UpdatePSActionAction.this.action);
                    }
                }
                ps.clearReviewRoleAction(UpdatePSActionAction.this.action);
                if (UpdatePSActionAction.this.roles != null) {
                    for (String roleName : UpdatePSActionAction.this.roles) {
                        ps.addReviewRoleAction(roleName, UpdatePSActionAction.this.action);
                    }
                }
                return "success";
            }
        });
    }
}

