/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.permschemes;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.crucible.spi.TxCallback;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.google.common.base.Strings;
import javax.annotation.Resource;
import org.springframework.transaction.TransactionStatus;

public class RenamePermSchemeAction
extends BaseAction {
    @Resource
    private PermissionManager permissionManager;
    private String newPSName;
    private Integer id;

    public String getNewPSName() {
        return this.newPSName;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setNewPSName(String newPSName) {
        if (newPSName != null) {
            newPSName = newPSName.trim();
        }
        this.newPSName = newPSName;
    }

    public String execute() throws Exception {
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                PermissionScheme ps = RenamePermSchemeAction.this.permissionManager.findPermissionSchemeById(RenamePermSchemeAction.this.id);
                if (ps == null) {
                    RenamePermSchemeAction.this.addActionError("Could not find Permission Scheme.");
                    return "error";
                }
                if (Strings.isNullOrEmpty((String)RenamePermSchemeAction.this.newPSName)) {
                    RenamePermSchemeAction.this.addActionError("Permission Scheme name must not be blank.");
                    return "error";
                }
                if (!ps.getName().equals(RenamePermSchemeAction.this.newPSName)) {
                    PermissionScheme newPS = RenamePermSchemeAction.this.permissionManager.findPermissionSchemeByName(RenamePermSchemeAction.this.newPSName);
                    if (newPS != null) {
                        RenamePermSchemeAction.this.addActionError("A Permission Scheme with that name exists.");
                        return "error";
                    }
                    ps.setName(RenamePermSchemeAction.this.newPSName);
                }
                return "success";
            }
        });
    }
}

