/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.permschemes;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.crucible.spi.TxCallback;
import com.cenqua.crucible.model.managers.PermissionManager;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.TransactionStatus;

public class NewPermSchemeAction
extends BaseAction {
    @Resource
    private PermissionManager permissionManager;
    private String name;
    private Integer id;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            name = name.trim();
        }
        this.name = name;
    }

    public Integer getId() {
        return this.id;
    }

    public String execute() throws Exception {
        if (StringUtils.isBlank((String)this.name)) {
            this.addActionError("A Permission scheme must not have a blank name");
            return "error";
        }
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                try {
                    NewPermSchemeAction.this.id = NewPermSchemeAction.this.permissionManager.createAgilePermissionSchemeWithName(NewPermSchemeAction.this.name).getId();
                    return "success";
                }
                catch (PermissionManager.DuplicatePermissionSchemeNameException e2) {
                    NewPermSchemeAction.this.addActionError(e2.getMessage());
                    return "error";
                }
            }
        });
    }
}

