/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.permschemes;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.crucible.spi.services.PermissionSchemeSearchCriteria;
import com.atlassian.crucible.spi.services.ProjectSearchCriteria;
import com.atlassian.crucible.spi.services.SearchCriteriaType;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.fisheye.web.paging.PagingCalculator;
import com.cenqua.fisheye.web.paging.TotalCountAwarePagingCalculator;
import com.google.common.collect.ImmutableList;
import javax.annotation.Resource;

public class ListPermSchemesAction
extends BaseAction {
    @Resource
    private PermissionManager permissionManager;
    private Iterable<PermSchemeData> permissionSchemes;
    private PagingCalculator pagingCalculator;

    private void initPermissionSchemes() {
        PermissionSchemeSearchCriteria permissionSchemeSearchCriteria = PermissionSchemeSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.PARTIAL_MATCH);
        String filterString = this.getParameter("filterString");
        if (filterString != null) {
            permissionSchemeSearchCriteria.name = filterString;
        } else {
            permissionSchemeSearchCriteria.all();
        }
        int permissionSchemeCount = this.permissionManager.countPermissionSchemes(permissionSchemeSearchCriteria);
        this.pagingCalculator = TotalCountAwarePagingCalculator.getPagingCalculator(this.getRequest(), permissionSchemeCount);
        PageRequest pageRequest = PageRequest.create((Integer)this.pagingCalculator.getCurrentPageStart(), (Integer)this.pagingCalculator.getNumPerPage());
        Page<PermissionScheme> permissionSchemePage = this.permissionManager.searchPermissionSchemes(permissionSchemeSearchCriteria, pageRequest);
        PermissionScheme defaultPermissionScheme = this.permissionManager.getDefaultPermissionScheme();
        Page permSchemeDataPage = permissionSchemePage.transform(permissionScheme -> {
            ProjectSearchCriteria projectsWithPermissionSchemeSearchCriteria = ProjectSearchCriteria.create((SearchCriteriaType)SearchCriteriaType.EXACT_MATCH).permissionSchemeName(permissionScheme.getName());
            int numberOfProjectsWithPermissionScheme = this.projectManager.countProjects(projectsWithPermissionSchemeSearchCriteria);
            Page<Project> projectPage = this.projectManager.searchAllProjects(projectsWithPermissionSchemeSearchCriteria, PageRequest.create((Integer)0, (Integer)3));
            return new PermSchemeData(permissionScheme.getId(), permissionScheme.getName(), permissionScheme.equals(defaultPermissionScheme), numberOfProjectsWithPermissionScheme, (ImmutableList<Project>)ImmutableList.copyOf((Iterable)projectPage.getValues()));
        });
        this.permissionSchemes = permSchemeDataPage.getValues();
    }

    public Iterable<PermSchemeData> getPermissionSchemes() {
        if (this.permissionSchemes == null) {
            this.initPermissionSchemes();
        }
        return this.permissionSchemes;
    }

    public PagingCalculator getPagingCalculator() {
        if (this.pagingCalculator == null) {
            this.initPermissionSchemes();
        }
        return this.pagingCalculator;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        return super.execute();
    }

    public static class PermSchemeData {
        public static final int MAX_NUMBER_OF_SOME_PROJECTS = 3;
        private final boolean defaultScheme;
        private final String name;
        private final Integer id;
        private final int numberOfProjects;
        private final ImmutableList<Project> someProjects;

        public PermSchemeData(Integer id, String name, boolean defaultScheme, int numberOfProjects, ImmutableList<Project> someProjects) {
            this.id = id;
            this.defaultScheme = defaultScheme;
            this.name = name;
            this.someProjects = someProjects;
            this.numberOfProjects = numberOfProjects;
        }

        public boolean isDefaultScheme() {
            return this.defaultScheme;
        }

        public String getName() {
            return this.name;
        }

        public Integer getId() {
            return this.id;
        }

        public boolean isAllowDeletion() {
            return !this.defaultScheme && this.numberOfProjects == 0;
        }

        public int getNumberOfProjects() {
            return this.numberOfProjects;
        }

        public ImmutableList<Project> getSomeProjects() {
            return this.someProjects;
        }
    }
}

