/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.permschemes;

import com.atlassian.crucible.actions.admin.permschemes.ActionData;
import com.atlassian.crucible.actions.admin.permschemes.BaseFormAction;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.principalAssociations.AllUserPA;
import com.cenqua.crucible.model.principalAssociations.AnonymousPA;
import com.cenqua.crucible.model.principalAssociations.GroupPA;
import com.cenqua.crucible.model.principalAssociations.RolePA;
import com.cenqua.crucible.model.principalAssociations.UserPA;
import com.cenqua.fisheye.logging.Logs;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;

public class EditPermSchemeAction
extends BaseFormAction {
    @Resource
    private PermissionManager permissionManager;
    private String name;
    private Integer id;
    private List<ActionData> actions;
    private static Comparator<ActionData> actionDataComparator = new Comparator<ActionData>(){

        @Override
        public int compare(ActionData o1, ActionData o2) {
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        }
    };

    public String getName() {
        return this.name;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public List<ActionData> getActions() {
        if (this.actions == null) {
            PermissionScheme ps = this.permissionManager.findPermissionSchemeById(this.id);
            if (ps == null) {
                Logs.APP_LOG.error((Object)("Permission Scheme not found: " + this.id));
                return Collections.emptyList();
            }
            this.actions = new LinkedList<ActionData>(this.mapPsActions(ps));
            Collections.sort(this.actions, actionDataComparator);
        }
        return this.actions;
    }

    private Collection<ActionData> mapPsActions(PermissionScheme ps) {
        ActionData ad2;
        LinkedHashMap<String, ActionData> actionMap = new LinkedHashMap<String, ActionData>();
        for (UserActionManager.Action action : UserActionManager.getInstance().getActions()) {
            actionMap.put(action.getName(), new ActionData(action));
        }
        for (AllUserPA allUserPA : ps.getAllUsersPAs()) {
            ActionData ad22 = (ActionData)actionMap.get(allUserPA.getActionName());
            if (ad22 == null) continue;
            ad22.setAllUsers(true);
        }
        for (AnonymousPA anonymousPA : ps.getAnonymousPAs()) {
            ad2 = (ActionData)actionMap.get(anonymousPA.getActionName());
            if (ad2 == null) continue;
            ad2.setAnonymousUsers(true);
        }
        for (UserPA userPA : ps.getUserPAs()) {
            ad2 = (ActionData)actionMap.get(userPA.getActionName());
            if (ad2 == null) continue;
            String userName = userPA.getPid();
            FecruUser user = this.userManager.getUser(userName);
            if (user != null) {
                ad2.addUser(user);
                continue;
            }
            Logs.APP_LOG.warn((Object)("User " + userName + " referenced in permission scheme " + ps.getName() + " was not found."));
        }
        for (GroupPA groupPA : ps.getGroupPAs()) {
            ad2 = (ActionData)actionMap.get(groupPA.getActionName());
            if (ad2 == null) continue;
            ad2.addGroup(groupPA.getPid());
        }
        for (RolePA rolePA : ps.getReviewRolePAs()) {
            ad2 = (ActionData)actionMap.get(rolePA.getActionName());
            if (ad2 == null) continue;
            ad2.addRole(rolePA.getPid());
        }
        return actionMap.values();
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        PermissionScheme ps = this.permissionManager.findPermissionSchemeById(this.id);
        if (ps == null) {
            Logs.APP_LOG.error((Object)("Permission Scheme not found: " + this.id));
            this.name = "";
        } else {
            this.name = ps.getName();
        }
        return super.execute();
    }
}

