/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.permschemes;

import com.atlassian.crucible.actions.admin.permschemes.ActionData;
import com.atlassian.crucible.actions.admin.permschemes.BaseFormAction;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.principalAssociations.AllUserPA;
import com.cenqua.crucible.model.principalAssociations.AnonymousPA;
import com.cenqua.crucible.model.principalAssociations.GroupPA;
import com.cenqua.crucible.model.principalAssociations.RolePA;
import com.cenqua.crucible.model.principalAssociations.UserPA;
import javax.annotation.Resource;

public class EditPSActionAction
extends BaseFormAction {
    @Resource
    private PermissionManager permissionManager;
    private ActionData actionData;
    private Integer psId;
    private String action;

    public void setPsId(Integer id) {
        this.psId = id;
    }

    public Integer getPsId() {
        return this.psId;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public ActionData getActionData() {
        if (this.actionData == null) {
            this.actionData = new ActionData(UserActionManager.getInstance().getAction(this.action));
            PermissionScheme pScheme = this.permissionManager.findPermissionSchemeById(this.psId);
            this.mapPsAction(pScheme, this.actionData);
        }
        return this.actionData;
    }

    private void mapPsAction(PermissionScheme ps, ActionData action) {
        for (AllUserPA allUserPA : ps.getAllUsersPAs()) {
            if (!allUserPA.getActionName().equals(action.getName())) continue;
            action.setAllUsers(true);
        }
        for (AnonymousPA anonymousPA : ps.getAnonymousPAs()) {
            if (!anonymousPA.getActionName().equals(action.getName())) continue;
            action.setAnonymousUsers(true);
        }
        for (UserPA userPA : ps.getUserPAs()) {
            FecruUser user;
            if (!userPA.getActionName().equals(action.getName()) || (user = this.userManager.getUser(userPA.getPid())) == null) continue;
            action.addUser(user);
        }
        for (GroupPA groupPA : ps.getGroupPAs()) {
            if (!groupPA.getActionName().equals(action.getName())) continue;
            action.addGroup(groupPA.getPid());
        }
        for (RolePA rolePA : ps.getReviewRolePAs()) {
            if (!rolePA.getActionName().equals(action.getName())) continue;
            action.addRole(rolePA.getPid());
        }
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        return super.execute();
    }
}

