/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.permschemes;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.crucible.spi.TxCallback;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import org.springframework.transaction.TransactionStatus;

public class DeletePermSchemeAction
extends BaseAction {
    @Resource
    private PermissionManager permissionManager;
    private Integer id;

    public void setId(Integer id) {
        this.id = id;
    }

    public String execute() throws Exception {
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                PermissionScheme ps = DeletePermSchemeAction.this.permissionManager.findPermissionSchemeById(DeletePermSchemeAction.this.id);
                if (ps == null) {
                    DeletePermSchemeAction.this.addActionError("Could not find Permission Scheme.");
                    return "error";
                }
                if (ps.equals(DeletePermSchemeAction.this.permissionManager.getDefaultPermissionScheme())) {
                    DeletePermSchemeAction.this.addActionError("Not allowed to delete the default Permission Scheme");
                    return "error";
                }
                Iterable<Project> projects = DeletePermSchemeAction.this.permissionManager.getProjectsUsingPermissionScheme(ps);
                if (!Iterables.isEmpty(projects)) {
                    DeletePermSchemeAction.this.addActionError("This Permission Scheme is used by some projects.");
                    return "error";
                }
                DeletePermSchemeAction.this.permissionManager.deletePermissionSchemeByName(ps.getName());
                return "success";
            }
        });
    }
}

