/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.permschemes;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.crucible.spi.TxCallback;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.managers.PermissionManager;
import javax.annotation.Resource;
import org.springframework.transaction.TransactionStatus;

public class CopyPermSchemeAction
extends BaseAction {
    @Resource
    private PermissionManager permissionManager;
    private String newPSName;
    private Integer id;

    public String getPsName() {
        return this.newPSName;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String execute() throws Exception {
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                PermissionScheme from = CopyPermSchemeAction.this.permissionManager.findPermissionSchemeById(CopyPermSchemeAction.this.id);
                if (from == null) {
                    CopyPermSchemeAction.this.addActionError("Could not find Permission Scheme.");
                    return "error";
                }
                int i2 = 1;
                CopyPermSchemeAction.this.newPSName = from.getName() + "(copy " + i2 + ")";
                PermissionScheme newPS = CopyPermSchemeAction.this.permissionManager.findPermissionSchemeByName(CopyPermSchemeAction.this.newPSName);
                while (newPS != null) {
                    CopyPermSchemeAction.this.newPSName = from.getName() + "(copy " + ++i2 + ")";
                    newPS = CopyPermSchemeAction.this.permissionManager.findPermissionSchemeByName(CopyPermSchemeAction.this.newPSName);
                }
                newPS = CopyPermSchemeAction.this.permissionManager.copyPermissionScheme(from, CopyPermSchemeAction.this.newPSName);
                if (newPS == null) {
                    CopyPermSchemeAction.this.addActionError("Problem creating Permission Scheme " + CopyPermSchemeAction.this.newPSName);
                    return "error";
                }
                CopyPermSchemeAction.this.id = newPS.getId();
                return "success";
            }
        });
    }
}

