/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.permschemes;

import com.atlassian.crucible.actions.admin.project.UserData;
import com.atlassian.crucible.actions.admin.project.data.ProjectDataUtils;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.fisheye.logging.Logs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ActionData {
    private boolean canBeAnonymous;
    private boolean isAnonymousUsers;
    private boolean isAllUsers;
    private Set<UserData> users = new HashSet<UserData>();
    private Set<String> groups = new HashSet<String>();
    private Set<String> roles = new HashSet<String>();
    private final UserActionManager.Action action;

    public ActionData(UserActionManager.Action action) {
        this.action = action;
    }

    public String getName() {
        return this.action.getName();
    }

    public String getDisplayName() {
        return this.action.getDisplayName();
    }

    public String getDescription() {
        return this.action.getPermissionDescription();
    }

    public boolean isAnonymousUsers() {
        return this.isAnonymousUsers;
    }

    public void setAnonymousUsers(boolean anonymousUsers) {
        this.isAnonymousUsers = anonymousUsers;
    }

    public boolean isAllUsers() {
        return this.isAllUsers;
    }

    public void setAllUsers(boolean allUsers) {
        this.isAllUsers = allUsers;
    }

    public Set<UserData> getUsers() {
        return this.users;
    }

    public List<String> getUsernames() {
        Set<UserData> users = this.getUsers();
        if (users == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(users.size());
        for (UserData user : users) {
            names.add(user.getUsername());
        }
        return names;
    }

    public void setUsers(Set<UserData> users) {
        this.users = users;
    }

    public void addUser(FecruUser user) {
        try {
            this.users.add(ProjectDataUtils.crucibleUserToUserData(user));
        }
        catch (Exception e2) {
            Logs.APP_LOG.debug((Object)"Problem adding user", (Throwable)e2);
        }
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public void addGroup(String groupName) {
        this.groups.add(groupName);
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void addRole(String roleName) {
        this.roles.add(roleName);
    }

    public boolean isCanBeAnonymous() {
        return this.action.allowsAnonymousPermission();
    }
}

