/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.database;

import com.atlassian.crucible.actions.admin.database.BaseDatabaseAction;
import com.atlassian.crucible.actions.admin.database.DBEditHelper;
import com.atlassian.event.api.EventPublisher;
import com.cenqua.crucible.hibernate.DbFooterMessageSource;
import javax.annotation.Resource;

public class UpdateDatabaseAction
extends BaseDatabaseAction {
    @Resource
    private DbFooterMessageSource dbFooterMessageSource;
    @Resource
    private EventPublisher eventPublisher;

    @Override
    public String execute() throws Exception {
        this.maybeUseCurrentPassword();
        this.validate();
        this.dbFooterMessageSource.resetTest();
        if (this.hasErrors()) {
            return "error";
        }
        try {
            DBEditHelper helper = new DBEditHelper(this.dbConfig, this.dbControlFactory, this, this.threadPool.getExecutor(), this.eventPublisher);
            String string = helper.changeDB() ? "success" : "error";
            return string;
        }
        finally {
            this.addDbErrors();
        }
    }

    public void validate() {
        if (this.dbConfig.getMinPoolSize() < 1) {
            this.addActionError("Minimum connection pool size must be greater than 1");
        }
        if (this.dbConfig.getMaxPoolSize() < 1) {
            this.addActionError("Maximum connection pool size must be greater than 1");
        }
        if (this.dbConfig.getMinPoolSize() > this.dbConfig.getMaxPoolSize()) {
            this.addActionError("Minimum connection pool size must be less than or equal to maximum connection pool size");
        }
    }
}

