/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.database;

import com.atlassian.crucible.actions.admin.database.BaseDatabaseAction;
import com.atlassian.crucible.actions.admin.database.DBEditHelper;
import com.atlassian.event.api.EventPublisher;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FishEyeClassLoader;
import com.cenqua.fisheye.FishEyeCtl;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.DriverSource;
import com.cenqua.fisheye.logging.Logs;
import java.io.File;
import javax.annotation.Resource;

public class TestDBConnectionAjaxAction
extends BaseDatabaseAction {
    private boolean sameUrl = false;
    private boolean configChanged = false;
    private String message;
    private static final String NO_DB = "no_db";
    @Resource
    private EventPublisher eventPublisher;

    @Override
    public String execute() throws Exception {
        DriverSource.Enum source = DriverSource.Enum.forString(this.dbConfig.getDriverSource());
        if (this.checkDriverClass(source)) {
            this.maybeUseCurrentPassword();
            if (source == DriverSource.BUNDLED) {
                RootConfig.addBundledDBDriver(FishEyeCtl.CLASSLOADER, this.dbConfig.getType());
            }
            DBEditHelper helper = new DBEditHelper(this.dbConfig, this.dbControlFactory, this, this.threadPool.getExecutor(), this.eventPublisher);
            this.message = helper.getTargetDBControl().getErrorMessage();
            this.sameUrl = helper.targetSameURL();
            this.configChanged = !helper.targetSameConfig();
            String result = helper.testConnection() ? "success" : NO_DB;
            for (String s2 : this.getActionErrors()) {
                this.message = this.message + "\n" + s2;
            }
            return result;
        }
        return NO_DB;
    }

    private boolean checkDriverClass(DriverSource.Enum source) {
        try {
            FishEyeClassLoader testLoader = FishEyeCtl.makeClassLoader((File)AppConfig.getAppHome(), (File)AppConfig.getInstanceDir());
            if (source == DriverSource.BUNDLED) {
                RootConfig.addBundledDBDriver(testLoader, this.dbConfig.getType());
            }
            Class<?> driverClass = Class.forName(this.dbConfig.getJdbcDriverClass(), true, (ClassLoader)testLoader);
            return true;
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)"Exception attempting to load Database driver", (Throwable)e2);
            this.message = source == DriverSource.USER ? "Unable to load database driver from your FISHEYE_INST/lib directory. Please check the JDBC  driver jar is properly installed" : "Unable to load bundled database driver class: " + e2.getMessage();
            return false;
        }
    }

    public boolean isSameUrl() {
        return this.sameUrl;
    }

    public boolean isConfigChanged() {
        return this.configChanged;
    }

    public String getMessage() {
        return this.message;
    }
}

