/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.database;

import com.atlassian.crucible.actions.admin.database.BaseDatabaseAction;
import com.atlassian.crucible.actions.admin.database.DBEditHelper;
import com.atlassian.crucible.maintenance.MaintenanceTask;
import com.atlassian.event.api.EventPublisher;
import com.cenqua.crucible.hibernate.AdminOperator;
import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.DbFooterMessageSource;
import com.cenqua.fisheye.logging.Logs;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

public class MigrateDatabaseAction
extends BaseDatabaseAction {
    private AsynchronousMigrater migrator;
    @Resource
    private DbFooterMessageSource dbFooterMessageSource;
    @Resource
    private EventPublisher eventPublisher;
    @Resource
    protected HttpServletRequest request;
    private String status = "";
    public static final String MIGRATION_PROGRESS_SESSION_KEY = MigrateDatabaseAction.class.getName() + ".migrationProgress";

    public DBControl getSourceDBControl() {
        return this.migrator.getSourceDBControl();
    }

    public DBControl getTargetDBControl() {
        return this.migrator.getTargetDBControl();
    }

    public boolean isFinished() {
        return this.migrator.isDone();
    }

    public boolean isFailed() {
        return !this.migrator.isSuccess();
    }

    public String getStatusMessage() {
        return this.status;
    }

    @Override
    public String execute() {
        this.maybeUseCurrentPassword();
        if (this.dbConfig.getType().equals((Object)DBType.HSQL)) {
            this.copyHSQLConnectionProperties(this.dbConfig);
        }
        this.migrator = new AsynchronousMigrater(new DBEditHelper(this.dbConfig, this.dbControlFactory, null, this.threadPool.getExecutor(), this.eventPublisher), this.dbFooterMessageSource);
        ExecutorService executor = this.threadPool.getExecutor();
        final AsynchronousMigrater finalMigrator = this.migrator;
        this.dbControlFactory.setAdminOperator(finalMigrator);
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    MigrateDatabaseAction.this.maintenanceManager.doMaintenance("Migrating the database.", new MaintenanceTask<Boolean, Exception>(){

                        @Override
                        public Boolean perform() throws Exception {
                            return finalMigrator.migrateToDB();
                        }
                    });
                }
                catch (Exception e2) {
                    Logs.APP_LOG.error((Object)"Unexpected error migrating databases.", (Throwable)e2);
                }
            }
        });
        this.request.getSession().setAttribute(MIGRATION_PROGRESS_SESSION_KEY, (Object)System.identityHashCode(this.migrator));
        return "success";
    }

    private void copyHSQLConnectionProperties(DatabaseConfig dbConfig) {
        dbConfig.setJdbcURL(this.getBuiltInConfig().getJdbcURL());
        dbConfig.setUsername(this.getBuiltInConfig().getUsername());
        dbConfig.setPassword(this.getBuiltInConfig().getPassword());
        dbConfig.setDriverSource(this.getBuiltInConfig().getDriverSource());
    }

    public static class AsynchronousMigrater
    implements AdminOperator {
        private final DBEditHelper helper;
        private final DbFooterMessageSource messageSource;
        private boolean done = false;
        private boolean success;

        public AsynchronousMigrater(DBEditHelper helper, DbFooterMessageSource messageSource) {
            this.helper = helper;
            this.messageSource = messageSource;
        }

        @Override
        public String getOperation() {
            return this.helper.getOperation();
        }

        @Override
        public String getStatusMessage() {
            return this.helper.getStatusMessage();
        }

        public boolean isSuccess() {
            return this.success;
        }

        public DBControl getSourceDBControl() {
            return this.helper.getSourceDBControl();
        }

        public DBControl getTargetDBControl() {
            return this.helper.getTargetDBControl();
        }

        public boolean isDone() {
            return this.done;
        }

        public boolean migrateToDB() {
            boolean exceptionOccured = true;
            try {
                this.success = this.helper.migrateToDB();
                exceptionOccured = false;
            }
            finally {
                if (exceptionOccured) {
                    this.success = false;
                }
                this.done = true;
            }
            this.messageSource.resetTest();
            return this.success;
        }
    }
}

