/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.database;

import com.atlassian.activeobjects.spi.Backup;
import com.atlassian.activeobjects.spi.BackupProgressMonitor;
import com.atlassian.activeobjects.spi.HotRestartEvent;
import com.atlassian.activeobjects.spi.RestoreProgressMonitor;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.item.ActiveObjectsBackup;
import com.atlassian.crucible.migration.item.DBExporter;
import com.atlassian.crucible.migration.item.DBImporter;
import com.atlassian.crucible.migration.item.Message;
import com.atlassian.crucible.migration.item.SQLBackup;
import com.atlassian.crucible.migration.xml.StAXStreamReader;
import com.atlassian.crucible.migration.xml.StAXStreamWriter;
import com.atlassian.event.api.EventPublisher;
import com.cenqua.crucible.hibernate.AdminOperator;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.DBInfo;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.ConnectionType;
import com.cenqua.fisheye.config1.DatabaseType;
import com.cenqua.fisheye.config1.DriverSource;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.JDBCHelper;
import com.google.common.base.Strings;
import com.opensymphony.xwork.ActionSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;

public class DBEditHelper
implements AdminOperator {
    private final DBControlFactory dbControlFactory;
    private final DBControl sourceDB;
    private final DBControl targetDB;
    private final ActionSupport actionSupport;
    private final StringBuilder log = new StringBuilder();
    private String operation = "";
    private static final int BUFFER_SIZE = 0x100000;
    private final ExecutorService executorService;
    private EventPublisher eventPublisher;

    public DBEditHelper(DatabaseConfig dbConfig, DBControlFactory dbControlFactory, ActionSupport actionSupport, ExecutorService executorService, EventPublisher eventPublisher) {
        this(dbControlFactory, dbControlFactory.getCurrentControl(), dbControlFactory.makeControl(dbConfig), actionSupport, executorService, eventPublisher);
    }

    public DBEditHelper(DBControlFactory dbControlFactory, DBControl sourceDB, DBControl targetDB, ActionSupport actionSupport, ExecutorService executorService, EventPublisher eventPublisher) {
        this.dbControlFactory = dbControlFactory;
        this.actionSupport = actionSupport == null ? new ActionSupport() : actionSupport;
        this.sourceDB = sourceDB;
        this.targetDB = targetDB;
        this.executorService = executorService;
        this.eventPublisher = eventPublisher;
    }

    public DBControl getSourceDBControl() {
        return this.sourceDB;
    }

    public DBControl getTargetDBControl() {
        return this.targetDB;
    }

    public boolean targetSameURL() {
        return this.targetDB.getInfo().getConnectionInfo().getJdbcURL().equals(this.sourceDB.getInfo().getConnectionInfo().getJdbcURL());
    }

    public boolean targetSameConfig() {
        return this.targetDB.getInfo().getConnectionInfo().equals(this.sourceDB.getInfo().getConnectionInfo());
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public String getStatusMessage() {
        return this.log.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testConnection() {
        if (this.targetDB.getInfo().state().equals((Object)DBInfo.DBState.NO_DB)) {
            this.actionSupport.addActionError("Couldn't connect to the database");
            return false;
        }
        Connection c2 = null;
        try {
            c2 = this.targetDB.getConnection();
            if (!this.targetDB.getInfo().type().isUTF8AndCaseSensitive(c2)) {
                this.actionSupport.addActionError("The database is not using case-sensitive Unicode. FishEye and Crucible require that the database is case-sensitive and uses a UTF8 encoding to support internalization.");
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Couldn't connect to DB", (Throwable)e2);
            this.actionSupport.addActionError("Couldn't connect to database: " + e2.getMessage() + ". See logs for details.");
            boolean bl = false;
            return bl;
        }
        finally {
            JDBCHelper.closeQuietly(c2);
        }
        return true;
    }

    public boolean changeDB() {
        if (!this.testConnection()) {
            return false;
        }
        this.log("Switching to new database at: " + this.targetDB.getInfo().getConnectionInfo().getJdbcURL() + "...");
        if (this.stopDB(this.sourceDB) && this.startNewDB(this.sourceDB, this.targetDB)) {
            this.save(this.targetDB);
            return true;
        }
        this.log("Error: failed to switch to new database.");
        return false;
    }

    private void save(DBControl dbControl) {
        if (AppConfig.getsConfig().getConfigDocument() != null) {
            ConnectionType connection;
            DatabaseType db;
            ConfigDocument.Config config = AppConfig.getsConfig().getConfigDocument().getConfig();
            DBInfo info = dbControl.getInfo();
            if (config.isSetDatabase()) {
                db = config.getDatabase();
                connection = db.getConnection();
            } else {
                db = config.addNewDatabase();
                connection = db.addNewConnection();
            }
            db.setType(info.type().getDbConfigType());
            connection.setDialect(info.getConnectionInfo().getDialect());
            connection.setDriver(info.getConnectionInfo().getJdbcDriverClass());
            connection.setJdbcurl(info.getConnectionInfo().getJdbcURL());
            connection.setPassword(info.getConnectionInfo().getPassword());
            connection.setUsername(info.getConnectionInfo().getUsername());
            connection.setMaxPoolSize(BigInteger.valueOf(info.getConnectionInfo().getMaxPoolSize()));
            connection.setMinPoolSize(BigInteger.valueOf(info.getConnectionInfo().getMinPoolSize()));
            connection.setDriverSource(DriverSource.Enum.forString(info.getConnectionInfo().getDriverSource()));
            String params = info.getConnectionInfo().getParams();
            if (!Strings.isNullOrEmpty((String)params)) {
                db.setParameters(params);
            } else if (db.isSetParameters()) {
                db.unsetParameters();
            }
            try {
                AppConfig.getsConfig().saveConfig();
                this.log("Complete");
            }
            catch (IOException e2) {
                this.dbControlFactory.addErrorMessage(e2.getMessage());
                Logs.APP_LOG.error((Object)"Couldn't save config data", (Throwable)e2);
            }
        } else {
            this.log("Configuration not saved - Complete");
            this.dbControlFactory.addErrorMessage("Configuration not saved. (no config found)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean migrateToDB() {
        if (this.targetSameURL()) {
            this.log("Error: Can't migrate to/from the same database.");
            return false;
        }
        this.operation = "Migrate Database";
        this.log("Started");
        PipedReader pipedReader = new PipedReader();
        ImportRunner importer = new ImportRunner(pipedReader);
        Connection conn = null;
        Future<Boolean> importFuture = null;
        Future<Boolean> exportFuture = null;
        boolean error = false;
        File aoBackupFile = null;
        boolean skipAO = false;
        Backup backup = null;
        try {
            aoBackupFile = File.createTempFile("activeobjects", ".backup");
            backup = (Backup)SpringContext.getComponent("backup");
            BufferedOutputStream aoOut = new BufferedOutputStream(new FileOutputStream(aoBackupFile));
            try {
                backup.save((OutputStream)aoOut, (BackupProgressMonitor)new ActiveObjectsBackup.ProgressMonitorAdaptor(new ProgressMonitor(){

                    @Override
                    public void update(Message resource) {
                        DBEditHelper.this.log(resource.getMessage());
                    }
                }));
            }
            catch (Exception e2) {
                Logs.APP_LOG.error((Object)"ActiveObjects backup failed. skipping", (Throwable)e2);
                this.log("Skipping ActiveObjects due to exception" + e2.getMessage());
                skipAO = true;
            }
            finally {
                IOUtils.closeQuietly((OutputStream)aoOut);
            }
            this.sourceDB.stop();
            conn = this.sourceDB.getConnection();
            ExportRunner export = new ExportRunner(new BufferedWriter(new PipedWriter(pipedReader), 0x100000), conn);
            importFuture = this.executorService.submit(importer);
            exportFuture = this.executorService.submit(export);
            if (!this.doGet(exportFuture)) {
                error = true;
            }
            if (!this.doGet(importFuture)) {
                error = true;
            }
            if (error) {
                this.handleMigrateException(exportFuture, importFuture, this.sourceDB);
                boolean bl = false;
                this.sourceDB.closeConnection(conn);
                this.closeReader(pipedReader);
                return bl;
            }
            this.sourceDB.closeConnection(conn);
            this.closeReader(pipedReader);
        }
        catch (Exception e3) {
            this.log(e3.getMessage());
            this.dbControlFactory.addErrorMessage(e3.getMessage());
            Logs.APP_LOG.error((Object)"Database migration failed", (Throwable)e3);
            this.handleMigrateException(exportFuture, importFuture, this.sourceDB);
            boolean export = false;
            return export;
        }
        finally {
            this.sourceDB.closeConnection(conn);
            this.closeReader(pipedReader);
        }
        boolean result = this.changeDB();
        if (result && !skipAO && aoBackupFile != null && backup != null) {
            BufferedInputStream aoIn = null;
            try {
                aoIn = new BufferedInputStream(new FileInputStream(aoBackupFile));
                backup.restore((InputStream)aoIn, (RestoreProgressMonitor)new ActiveObjectsBackup.ProgressMonitorAdaptor(new ProgressMonitor(){

                    @Override
                    public void update(Message resource) {
                        DBEditHelper.this.log(resource.getMessage());
                    }
                }));
            }
            catch (Exception e4) {
                try {
                    Logs.APP_LOG.error((Object)"Database migration failed", (Throwable)e4);
                    this.log("Failed to restore ActiveObjects backup :" + e4.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(aoIn);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)aoIn);
            }
            IOUtils.closeQuietly((InputStream)aoIn);
        }
        return result;
    }

    private void handleMigrateException(Future exportFuture, Future importFuture, DBControl control) {
        this.cancelFuture(exportFuture, importFuture);
        try {
            control.start();
        }
        catch (CruDBException e2) {
            String message = String.format("Unable to restart original database (%s) after error; shutting down: %s: %s", control.getInfo().getConnectionInfo().getJdbcURL(), e2.getClass().getName(), e2.getMessage());
            Logs.APP_LOG.fatal((Object)message, (Throwable)e2);
            System.exit(1);
        }
    }

    private void cancelFuture(Future ... future) {
        for (Future f2 : future) {
            if (f2 == null) continue;
            f2.cancel(true);
        }
    }

    private boolean doGet(Future future) {
        try {
            future.get();
        }
        catch (Exception e2) {
            Throwable cause = e2;
            if (e2 instanceof ExecutionException) {
                cause = e2.getCause();
            }
            this.log(cause.getMessage());
            this.dbControlFactory.addErrorMessage(cause.getMessage());
            String message = String.format("Database migration failed: %s: %s", cause.getClass().getName(), cause.getMessage());
            Logs.APP_LOG.error((Object)message, cause);
            this.log(message);
            return false;
        }
        return true;
    }

    private void closeReader(Reader r2) {
        try {
            r2.close();
        }
        catch (IOException e2) {
            String message = String.format("Problem closing db import reader: %s: %s", e2.getClass().getName(), e2.getMessage());
            Logs.APP_LOG.error((Object)message, (Throwable)e2);
            this.log(message);
        }
    }

    public boolean stopDB(DBControl dbControl) {
        try {
            dbControl.stop();
            return true;
        }
        catch (CruDBException e2) {
            String message = String.format("Failed to stop database (%s): %s: %s", dbControl.getInfo().getConnectionInfo().getJdbcURL(), e2.getClass().getName(), e2.getMessage());
            this.actionSupport.addActionError(message);
            Logs.APP_LOG.error((Object)message, (Throwable)e2);
            this.log(message);
            return false;
        }
    }

    public boolean startNewDB(DBControl currentControl, DBControl newControl) {
        this.dbControlFactory.setCurrentControl(newControl);
        try {
            newControl.start();
            this.eventPublisher.publish((Object)HotRestartEvent.INSTANCE);
        }
        catch (CruDBException e2) {
            this.handleStartError(currentControl, e2);
            return false;
        }
        catch (IllegalStateException e3) {
            this.handleStartError(currentControl, e3);
            return false;
        }
        return true;
    }

    public void revertDB(DBControl dbControl) {
        this.dbControlFactory.setCurrentControl(dbControl);
        try {
            dbControl.start();
        }
        catch (CruDBException e2) {
            String message = String.format("Problem re-starting current database (%s): %s: %s", dbControl.getInfo().getConnectionInfo().getJdbcURL(), e2.getClass().getName(), e2.getMessage());
            Logs.APP_LOG.error((Object)message, (Throwable)e2);
            this.actionSupport.addActionError(message);
            this.log(message);
        }
    }

    private void handleStartError(DBControl dbControl, Exception e2) {
        String message = String.format("Problem starting database (%s): %s: %s", dbControl.getInfo().getConnectionInfo().getJdbcURL(), e2.getClass().getName(), e2.getMessage());
        Logs.APP_LOG.error((Object)message, (Throwable)e2);
        this.log(message);
        this.actionSupport.addActionError(e2.getMessage());
        this.revertDB(dbControl);
    }

    private synchronized void log(String message) {
        this.log.append(message + "\n");
    }

    private class ExportRunner
    implements Callable<Boolean> {
        final Writer writer;
        private Connection conn;

        private ExportRunner(Writer writer, Connection conn) {
            this.writer = writer;
            this.conn = conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            Boolean bl;
            StAXStreamWriter nswriter = null;
            try {
                nswriter = new StAXStreamWriter(this.writer, "http://www.atlassian.com/fisheye/backup-1");
                DBExporter exporter = new DBExporter(SQLBackup.IS_EXPORTABLE_TABLE, resource -> {
                    if (resource.isWarning()) {
                        DBEditHelper.this.log(resource.getMessage());
                    }
                });
                exporter.exportData(DBEditHelper.this.sourceDB.getInfo().type(), this.conn, nswriter);
                bl = true;
            }
            catch (Throwable throwable) {
                IOHelper.close(nswriter);
                throw throwable;
            }
            IOHelper.close(nswriter);
            return bl;
        }
    }

    private class ImportRunner
    implements Callable<Boolean> {
        final Reader reader;

        private ImportRunner(Reader reader) {
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            Boolean bl;
            StAXStreamReader nsreader = null;
            try {
                nsreader = new StAXStreamReader(new BufferedReader(this.reader, 0x100000));
                DBImporter importer = new DBImporter(new ProgressMonitor(){

                    @Override
                    public void update(Message resource) {
                        DBEditHelper.this.log(resource.getMessage());
                    }
                });
                importer.importData(nsreader, DBEditHelper.this.targetDB);
                bl = true;
            }
            catch (Throwable throwable) {
                IOHelper.close(nsreader, this.reader);
                throw throwable;
            }
            IOHelper.close(nsreader, this.reader);
            return bl;
        }
    }
}

