/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin.database;

import com.atlassian.crucible.maintenance.MaintenanceManager;
import com.atlassian.crucible.resource.ThreadPool;
import com.atlassian.xwork.ParameterSafe;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.DriverSource;
import com.opensymphony.xwork.ActionSupport;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseDatabaseAction
extends ActionSupport {
    @Resource
    protected DBControlFactory dbControlFactory;
    @Resource
    protected ThreadPool threadPool;
    @Resource
    protected MaintenanceManager maintenanceManager;
    protected boolean passwordChanged;
    protected DatabaseConfig dbConfig;
    protected HashMap<String, DbTypeOption> dbTypes;
    private Map<String, String> driverSources;
    private boolean editMode = false;
    private static final String EDIT = "edit";

    public DatabaseConfig getBuiltInConfig() {
        return this.dbControlFactory.getDefaultDBConfig();
    }

    private void initDBConfig() {
        this.dbConfig = new DatabaseConfig(this.dbControlFactory.getCurrentControl().getInfo().getConnectionInfo());
        DBType selectedDBType = this.dbConfig.getType();
        this.dbTypes = new HashMap();
        for (DBType t2 : DBType.values()) {
            this.dbTypes.put(t2.name(), new DbTypeOption(t2, t2.equals((Object)selectedDBType)));
        }
        this.driverSources = new LinkedHashMap<String, String>();
        this.driverSources.put(DriverSource.USER.toString(), "User Supplied - FISHEYE_INST/lib");
        if (AppConfig.getBundledDriverDir().exists()) {
            this.driverSources.put(DriverSource.BUNDLED.toString(), "Bundled");
        }
    }

    @Autowired
    public void setDbControlFactory(DBControlFactory dbControlFactory) {
        this.dbControlFactory = dbControlFactory;
        this.initDBConfig();
    }

    @Autowired
    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    @Autowired
    public void setMaintenanceManager(MaintenanceManager maintenanceManager) {
        this.maintenanceManager = maintenanceManager;
    }

    @ParameterSafe
    public DatabaseConfig getDbConfig() {
        return this.dbConfig;
    }

    public Map<String, DbTypeOption> getDbTypes() {
        return this.dbTypes;
    }

    public Map<String, String> getDriverSources() {
        return this.driverSources;
    }

    public boolean isBuiltIn() {
        return DBType.HSQL.equals((Object)this.dbConfig.getType());
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public void setPasswordChanged(boolean passwordChanged) {
        this.passwordChanged = passwordChanged;
    }

    protected void maybeUseCurrentPassword() {
        if (!this.passwordChanged) {
            this.dbConfig.setPassword(this.dbControlFactory.getCurrentControl().getInfo().getConnectionInfo().getPassword());
        }
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        this.ensureDBConfigPropsIfHSQL();
        this.addDbErrors();
        if (this.editMode) {
            return EDIT;
        }
        return "success";
    }

    private void ensureDBConfigPropsIfHSQL() {
        if (this.dbConfig.getType() == DBType.HSQL) {
            DatabaseConfig builtInConfig = this.getBuiltInConfig();
            this.dbConfig.setJdbcURL(builtInConfig.getJdbcURL());
            this.dbConfig.setDriverSource(builtInConfig.getDriverSource());
            this.dbConfig.setUsername(builtInConfig.getUsername());
            this.dbConfig.setPassword(builtInConfig.getPassword());
        }
    }

    public void addDbErrors() {
        List<String> errors = this.dbControlFactory.getErrorMessages();
        for (String err : errors) {
            this.addActionError(err);
        }
    }

    public static class DbTypeOption {
        DBType dbType;
        boolean selected = false;

        public DbTypeOption(DBType dbType, boolean selected) {
            this.dbType = dbType;
            this.selected = selected;
        }

        public DBType getDbType() {
            return this.dbType;
        }

        public String getSelected() {
            return this.selected ? "selected='true'" : "";
        }
    }
}

