/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.Project;
import com.cenqua.fisheye.config.RootConfig;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class SnippetAdminAction
extends BaseAction {
    private List<ProjectData> projects;
    private Integer defaultProjectId;
    private RootConfig rootConfig;

    public SnippetAdminAction() {
    }

    @Autowired
    public SnippetAdminAction(RootConfig rootConfig) {
        this.rootConfig = rootConfig;
        this.defaultProjectId = rootConfig.getConfig().getSnippet().isSetDefaultProjectId() ? Integer.valueOf(rootConfig.getConfig().getSnippet().getDefaultProjectId()) : Integer.valueOf(-1);
    }

    public Integer getDefaultProjectId() {
        return this.defaultProjectId;
    }

    public void setDefaultProjectId(Integer defaultProjectId) {
        this.defaultProjectId = defaultProjectId;
    }

    public List<ProjectData> getAllProjects() {
        if (this.projects == null) {
            this.projects = new ArrayList<ProjectData>();
            if (this.defaultProjectId == null || this.defaultProjectId == -1) {
                this.projects.add(new ProjectData(-1, "None Selected"));
            }
            for (Project p2 : this.projectManager.getAllProjects()) {
                this.projects.add(new ProjectData(p2.getId(), p2.getName()));
            }
        }
        return this.projects;
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    public String execute() throws Exception {
        if (this.defaultProjectId != null && this.defaultProjectId != -1) {
            Project p2 = this.projectManager.getProjectById(this.defaultProjectId);
            if (p2 == null) {
                this.addActionError("Project with id " + this.defaultProjectId + " not found.");
            } else {
                this.rootConfig.getConfig().getSnippet().setDefaultProjectId(this.defaultProjectId);
            }
        }
        return "success";
    }

    private static class ProjectData {
        private int id;
        private String name;

        public ProjectData(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

