/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions.admin;

import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.crucible.configuration.metrics.FieldDefinition;
import com.atlassian.crucible.configuration.metrics.MetricsConfig;
import com.atlassian.crucible.configuration.metrics.MetricsManager;
import com.atlassian.crucible.configuration.metrics.XMLValidationException;
import com.atlassian.xwork.RequireSecurityToken;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.opensymphony.webwork.interceptor.ParameterAware;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xmlbeans.XmlError;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EditDefectClassificationsAction
extends BaseAction
implements ParameterAware {
    private static final Pattern VALID_METRIC_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9\\-]+$");
    private Collection<FieldDefinition> comments;
    private Map parameters;
    private final List<Field> fields = new ArrayList<Field>();

    public EditDefectClassificationsAction() {
        this.loadComments();
    }

    public Integer getMetricsVersion() {
        return MetricsManager.INSTANCE.getLatestVersion();
    }

    public Collection<FieldDefinition> getComments() {
        return this.comments;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    @RequireSecurityToken(value=false)
    public String doDefault() throws Exception {
        return "input";
    }

    public String execute() throws Exception {
        if ("POST".equals(this.getRequest().getMethod()) && this.parseParams()) {
            Document doc = this.constructXml();
            if (doc != null) {
                this.commitXml(doc);
            }
            if (!this.getActionErrors().isEmpty()) {
                return "input";
            }
            this.loadComments();
            return "success";
        }
        return "input";
    }

    private void loadComments() {
        if (this.getMetricsVersion() == null) {
            return;
        }
        MetricsConfig mc = MetricsManager.INSTANCE.getConfig(this.getMetricsVersion());
        if (mc == null) {
            return;
        }
        this.comments = mc.isValid() ? ImmutableSet.copyOf((Collection)Collections2.filter(mc.getCommentFields().values(), (Predicate)new Predicate<FieldDefinition>(){

            public boolean apply(FieldDefinition input) {
                if (!EditDefectClassificationsAction.isNameValid(input.getName())) {
                    EditDefectClassificationsAction.this.addActionMessage("Ignoring invalid metric name of " + input.getName());
                    return false;
                }
                return true;
            }
        })) : Collections.emptySet();
    }

    private boolean parseParams() {
        this.fields.clear();
        if (this.parameters == null) {
            return false;
        }
        String[] fieldParams = (String[])this.parameters.get("fields");
        if (fieldParams == null) {
            return false;
        }
        for (String name : fieldParams) {
            if (!EditDefectClassificationsAction.isNameValid(name)) {
                this.addActionError("Invalid custom defect classification name: " + name);
                continue;
            }
            String[] labels = (String[])this.parameters.get("label[" + name + "]");
            if (labels == null || labels.length == 0) {
                this.addActionError("Label can't be empty");
                return false;
            }
            String label = labels[0];
            if (Strings.isNullOrEmpty((String)label)) {
                this.addActionError("Label can't be empty");
                return false;
            }
            Field f2 = new Field(name, label, "integer");
            String key = "values[" + name + "]";
            if (this.parameters.containsKey(key)) {
                List<String> values = Arrays.asList((String[])this.parameters.get(key));
                for (String s2 : values) {
                    if (Strings.isNullOrEmpty((String)s2)) continue;
                    f2.addValue(new Value(s2));
                }
            }
            if (!f2.hasValues()) {
                this.addActionError("Classification " + label + " has no values");
            }
            this.fields.add(f2);
        }
        return this.getActionErrors().isEmpty();
    }

    static boolean isNameValid(String name) {
        return !Strings.isNullOrEmpty((String)name) && VALID_METRIC_NAME_PATTERN.matcher(name).matches();
    }

    private String stringifyXml(Document doc) {
        String xmlString = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            xmlString = result.getWriter().toString();
        }
        catch (Exception e2) {
            this.addActionMessage("Unable to create classification metrics configuration file.");
            e2.printStackTrace();
        }
        return xmlString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitXml(Document doc) {
        String xml = this.stringifyXml(doc);
        if (Strings.isNullOrEmpty((String)xml)) {
            return;
        }
        try {
            this.beginTx();
            Integer version = MetricsManager.INSTANCE.storeNewConfig(xml, false);
            if (version == -1) {
                this.addActionMessage("Metrics config is identical to the current version.");
            } else {
                this.addActionMessage("Saved metrics config as version " + version);
            }
            this.commitTx();
        }
        catch (XMLValidationException e2) {
            this.addActionError("There was a problem setting the metrics configuration:");
            for (Object error1 : e2.getErrors()) {
                XmlError error = (XmlError)error1;
                String errorMsg = error.getMessage();
                if (error.getLine() != -1) {
                    errorMsg = errorMsg + " on line " + error.getLine();
                }
                if (error.getColumn() != -1) {
                    errorMsg = errorMsg + " column " + error.getColumn();
                }
                this.addActionError(errorMsg);
            }
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    private Document constructXml() {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            doc = impl.createDocument("http://www.cenqua.com/crucible/metrics-1", "metrics", null);
            Element root = doc.getDocumentElement();
            Element commentElement = doc.createElement("comment");
            root.appendChild(commentElement);
            for (Field field : this.fields) {
                Element fieldElement = this.constructFieldElement(field, doc);
                commentElement.appendChild(fieldElement);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return doc;
    }

    private Element constructFieldElement(Field field, Document doc) {
        Element fieldElement = doc.createElement("field");
        fieldElement.setAttribute("name", field.name);
        Element e2 = doc.createElement("label");
        Text n2 = doc.createTextNode(field.label);
        e2.appendChild(n2);
        fieldElement.appendChild(e2);
        e2 = doc.createElement("type");
        Element typeElem = doc.createElement(field.type);
        e2.appendChild(typeElem);
        fieldElement.appendChild(e2);
        e2 = doc.createElement("select");
        int i2 = 0;
        for (Value value : field.values) {
            Element option = doc.createElement("option");
            option.setAttribute("value", String.valueOf(i2));
            n2 = doc.createTextNode(value.name);
            option.appendChild(n2);
            e2.appendChild(option);
            ++i2;
        }
        fieldElement.appendChild(e2);
        return fieldElement;
    }

    private static final class Field {
        private final String name;
        private final String label;
        private final String type;
        private final List<Value> values = new ArrayList<Value>();

        Field(String name, String label, String type) {
            this.name = name;
            this.label = label;
            this.type = type;
        }

        void addValue(Value value) {
            this.values.add(value);
        }

        boolean hasValues() {
            return !this.values.isEmpty();
        }
    }

    private static final class Value {
        private final String name;

        Value(String name) {
            this.name = name;
        }
    }
}

