/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FRXRevisionManager;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.fisheye.logging.Logs;
import org.springframework.transaction.TransactionStatus;

public class ViewFRXAction
extends ReviewBaseAction
implements AjaxResponse {
    private String frxPermaId;
    private boolean showAnnotation;
    private FRXDO frxDO;
    private int u = 3;
    private boolean ignore_BL = true;
    private boolean ignore_w = false;
    private boolean ignore_b = true;
    private int frxid = -1;
    private String errorMsg;
    private boolean worked = true;
    private boolean overrideDiffView = false;
    private boolean sideBySide = false;
    private boolean showDiffContextBar = false;
    private Integer fromRev;
    private Integer toRev;

    public void setActionPathInfo(String frxPermaId) {
        this.frxPermaId = frxPermaId.substring(1);
    }

    public String getFrxPermaId() {
        return this.frxPermaId;
    }

    public void setFrxid(int frxid) {
        this.frxid = frxid;
    }

    public void setFromRev(Integer fromRev) {
        this.fromRev = fromRev;
    }

    public void setToRev(Integer toRev) {
        this.toRev = toRev;
    }

    protected Integer getFromRev() {
        return this.fromRev;
    }

    protected Integer getToRev() {
        return this.toRev;
    }

    public FRXDO getFrxDO() {
        return this.frxDO;
    }

    public void setShowAnnotation(boolean showAnnotation) {
        this.showAnnotation = showAnnotation;
    }

    public boolean isShowAnnotation() {
        return this.showAnnotation;
    }

    public void setShowDiffContextBar(boolean showDiffContextBar) {
        this.showDiffContextBar = showDiffContextBar;
    }

    public boolean isShowDiffContextBar() {
        return this.showDiffContextBar;
    }

    public int getU() {
        return this.u;
    }

    public void setU(int u2) {
        this.u = u2;
    }

    public boolean isIgnore_BL() {
        return this.ignore_BL;
    }

    public void setIgnore_BL(boolean ignore_BL) {
        this.ignore_BL = ignore_BL;
    }

    public void setBl(boolean ignore_BL) {
        this.ignore_BL = ignore_BL;
    }

    public boolean isIgnore_w() {
        return this.ignore_w;
    }

    public void setIgnore_w(boolean ignore_w) {
        this.ignore_w = ignore_w;
    }

    public boolean isIgnore_b() {
        return this.ignore_b;
    }

    public void setIgnore_b(boolean ignore_b) {
        this.ignore_b = ignore_b;
    }

    public void setWs(String val) {
        this.ignore_b = false;
        this.ignore_w = false;
        if ("b".equals(val)) {
            this.ignore_b = true;
        } else if ("w".equals(val)) {
            this.ignore_w = true;
        }
    }

    public void setFv(String type) {
        boolean bl = this.overrideDiffView = "s".equalsIgnoreCase(type) || "u".equalsIgnoreCase(type);
        if (this.overrideDiffView) {
            this.sideBySide = "s".equalsIgnoreCase(type);
        }
    }

    public String getIgnore2() {
        return (this.ignore_b ? "b" : "") + (this.ignore_w ? "w" : "");
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getError() {
        return "error.general";
    }

    public String getErrorDescription() {
        return this.getErrorMsg();
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        try {
            return this.txTemplate.execute(new TxCallback<String>(){

                @Override
                public String doInTransaction(TransactionStatus status) throws Exception {
                    String errorSuf;
                    FileRevisionExtraInfo frx;
                    FRXRevisionManager frxRevisionManager = new FRXRevisionManager();
                    if (ViewFRXAction.this.frxid != -1) {
                        frx = FRXManager.getById(ViewFRXAction.this.frxid);
                        errorSuf = "file revision ID " + ViewFRXAction.this.frxid;
                    } else {
                        frx = FRXManager.getByPermaId(ViewFRXAction.this.frxPermaId);
                        errorSuf = "file revision PermaId " + ViewFRXAction.this.frxPermaId;
                    }
                    if (frx == null) {
                        ViewFRXAction.this.errorMsg = "Can't find files referenced by " + errorSuf;
                        ViewFRXAction.this.worked = false;
                        return "error";
                    }
                    if (frx.getFrxRevisions() == null || frx.getFrxRevisions().size() == 0) {
                        throw new Exception("Cannot find any revisions in FRX with id \"" + ViewFRXAction.this.frxid + "\"");
                    }
                    FRXRevision to = ViewFRXAction.this.toRev == null ? null : frxRevisionManager.getById(ViewFRXAction.this.toRev);
                    FRXRevision from = ViewFRXAction.this.fromRev == null ? null : frxRevisionManager.getById(ViewFRXAction.this.fromRev);
                    ViewFRXAction.this.frxDO = ViewFRXAction.this.makeFRXDO(frx, true);
                    if (to != null) {
                        ViewFRXAction.this.frxDO.setToFrxRevision(to);
                        ViewFRXAction.this.frxDO.resetDiff();
                    }
                    if (from != null) {
                        ViewFRXAction.this.frxDO.setFromFrxRevision(from);
                        ViewFRXAction.this.frxDO.resetDiff();
                    }
                    if (ViewFRXAction.this.showAnnotation) {
                        ViewFRXAction.this.frxDO.setFromFrxRevision(null);
                    }
                    if (ViewFRXAction.this.overrideDiffView) {
                        ViewFRXAction.this.frxDO.setSideBySide(ViewFRXAction.this.sideBySide);
                    }
                    ViewFRXAction.this.frxDO.setDiffContext(ViewFRXAction.this.u);
                    ViewFRXAction.this.frxDO.setIgnore_BL(ViewFRXAction.this.ignore_BL);
                    ViewFRXAction.this.frxDO.setIgnore_b(ViewFRXAction.this.ignore_b);
                    ViewFRXAction.this.frxDO.setIgnore_w(ViewFRXAction.this.ignore_w);
                    ViewFRXAction.this.frxDO.mapInlineComments();
                    return "success";
                }
            });
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Problem creating FRXDO from frx", (Throwable)e2);
            this.errorMsg = "Problem creating FRXDO from frx: " + e2.getMessage();
            this.worked = false;
            return "error";
        }
    }

    public boolean isReloadReview() {
        return false;
    }
}

