/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.ReviewMutableProperties;
import com.cenqua.crucible.model.managers.SnippetManager;
import com.cenqua.fisheye.config.RootConfig;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class UpdateSnippetSyntaxAjaxAction
extends ReviewBaseAction
implements AjaxResponse {
    private String errorMsg;
    private Boolean worked = false;
    private String synhi;
    private String newSynhiName;
    @Autowired
    RootConfig rootConfig;
    @Autowired
    SnippetManager snippetManager;

    public String getNewSynhiName() {
        return this.newSynhiName;
    }

    public void setNewSynhiName(String newSynhiName) {
        this.newSynhiName = newSynhiName;
    }

    public String getSynhi() {
        return this.synhi;
    }

    public void setSynhi(String extension) {
        this.synhi = extension;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        this.worked = false;
        if (this.getCurrentUser() == null) {
            this.errorMsg = "Cannot update syntax highlighting as you are not logged in.";
            return "ajaxError";
        }
        if (this.getReview().getState().isClosedMetaState()) {
            this.errorMsg = "Cannot edit details of a closed snippet.";
            return "ajaxError";
        }
        if (!this.getReview().isSnippet()) {
            this.errorMsg = "Cannot update syntax highlighting as the review is not a snippet.";
            return "ajaxError";
        }
        CrucibleRevision revision = this.snippetManager.getSnippetRevision(this.getReview());
        HibernateUtil.beginTransaction();
        try {
            String newName;
            String oldSynhi = revision.getSnippetSyntax();
            String oldSynhiName = null;
            for (Map.Entry<String, String> syntax : this.rootConfig.getSyntaxDefinitions().getSyntaxTypes().entrySet()) {
                if (!syntax.getValue().equals(oldSynhi)) continue;
                oldSynhiName = syntax.getKey();
                break;
            }
            if (!StringUtils.isEmpty((String)(newName = this.snippetManager.reconstructSnippetName(this.getReview().getName(), oldSynhiName, this.newSynhiName)))) {
                LogManager.logReviewPropertyChanged(ReviewMutableProperties.TITLE, this.getReview(), this.getCurrentUser(), this.getReview().getName(), newName);
                this.getReview().setName(newName);
            }
            revision.setSnippetSyntax(this.synhi);
            this.commitTx();
            this.worked = true;
        }
        finally {
            HibernateUtil.rollbackTransactionIfNotCommitted();
        }
        return this.worked != false ? "success" : "ajaxError";
    }
}

