/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.crucible.event.ReviewUpdatedEventImpl;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.ReviewMutableProperties;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.fisheye.util.StringUtil;
import javax.annotation.Resource;

public class UpdateReviewTitleAjaxAction
extends ReviewBaseAction
implements AjaxResponse {
    private String title;
    private String adgified;
    private Boolean isAdgified;
    private String errorMsg;
    private boolean worked;
    @Resource
    private SPIUtils spiUtils;

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected void log(ReviewMutableProperties property, String oldValue, String newValue) {
        LogManager.logReviewPropertyChanged(property, this.getReview(), this.getCurrentUser(), oldValue, newValue);
    }

    private boolean changed(String newVal, String currentVal) {
        return !StringUtil.equalsWithNullsAsEmpty(newVal, currentVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        Review review = this.getReview();
        if (review.getState().isClosedMetaState()) {
            this.errorMsg = "Cannot edit details of a closed review.";
            this.worked = false;
            return "ajaxError";
        }
        if (!this.isFileModifiable()) {
            UserActionManager userActionManager = UserActionManager.getInstance();
            this.errorMsg = userActionManager.getAction(UserActionManager.ACTION_MOD_FILES).getPermissionViolationMsg();
            this.worked = false;
            return "ajaxError";
        }
        try {
            this.beginTx();
            boolean updated = false;
            ReviewData oldReviewData = this.spiUtils.createReviewData(review);
            if (this.changed(this.title, review.getName())) {
                this.log(ReviewMutableProperties.TITLE, review.getName(), this.title);
                review.setName(this.title);
                updated = true;
            }
            this.isAdgified = this.adgified != null && this.adgified.equals("true") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.commitTx();
            if (updated) {
                this.eventPublisher.publish((Object)new ReviewUpdatedEventImpl(review.getPermId(), this.getCurrentUserData(), oldReviewData));
            }
            this.worked = true;
            String string = "success";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    public void setAdgified(String adgified) {
        this.adgified = adgified;
    }

    public Boolean getIsAdgified() {
        return this.isAdgified;
    }
}

