/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FRXRevisionManager;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.fisheye.logging.Logs;

public class UpdateFrxViewAjaxAction
extends ReviewBaseAction
implements AjaxResponse {
    private int frxid;
    private FRXDO frxDO;
    private String errorMsg;
    private boolean worked = true;
    private Integer fromRev;
    private Integer toRev;
    private Integer u = null;
    private boolean ignore_BL = true;
    private boolean ignore_w = false;
    private boolean ignore_b = true;
    private boolean forcedDiffView = false;
    private boolean sideBySide = false;
    private boolean showDiffContextBar = false;
    private String fv;

    public Integer getFromRev() {
        return this.fromRev;
    }

    public void setFromRev(Integer fromRev) {
        this.fromRev = fromRev;
    }

    public Integer getToRev() {
        return this.toRev;
    }

    public void setToRev(Integer toRev) {
        this.toRev = toRev;
    }

    public void setFrxid(int frxid) {
        this.frxid = frxid;
    }

    public FRXDO getFrxDO() {
        return this.frxDO;
    }

    public void setShowDiffContextBar(boolean showDiffContextBar) {
        this.showDiffContextBar = showDiffContextBar;
    }

    public boolean isShowDiffContextBar() {
        return this.showDiffContextBar;
    }

    public int getU() {
        return this.u;
    }

    public void setU(int u2) {
        this.u = u2;
    }

    public boolean isIgnore_BL() {
        return this.ignore_BL;
    }

    public void setIgnore_BL(boolean ignore_BL) {
        this.ignore_BL = ignore_BL;
    }

    public void setBl(boolean ignore_BL) {
        this.ignore_BL = ignore_BL;
    }

    public boolean isIgnore_w() {
        return this.ignore_w;
    }

    public void setIgnore_w(boolean ignore_w) {
        this.ignore_w = ignore_w;
    }

    public boolean isIgnore_b() {
        return this.ignore_b;
    }

    public void setIgnore_b(boolean ignore_b) {
        this.ignore_b = ignore_b;
    }

    public void setWs(String val) {
        this.ignore_b = false;
        this.ignore_w = false;
        if ("b".equals(val)) {
            this.ignore_b = true;
        } else if ("w".equals(val)) {
            this.ignore_w = true;
        }
    }

    public void setFv(String fv) {
        this.fv = fv;
        boolean bl = this.forcedDiffView = "s".equalsIgnoreCase(fv) || "u".equalsIgnoreCase(fv);
        if (this.forcedDiffView) {
            this.sideBySide = "s".equalsIgnoreCase(fv);
        }
    }

    public String getFv() {
        return this.fv;
    }

    public String getIgnore2() {
        return (this.ignore_b ? "b" : "") + (this.ignore_w ? "w" : "");
    }

    public boolean isForcedDiffView() {
        return this.forcedDiffView;
    }

    public boolean getSideBySide() {
        return this.sideBySide;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        try {
            FRXRevision from;
            FRXRevisionManager frxRevisionManager = new FRXRevisionManager();
            this.beginTx();
            FileRevisionExtraInfo frx = FRXManager.getById(this.frxid);
            if (frx.getFrxRevisions() == null || frx.getFrxRevisions().size() == 0) {
                throw new Exception("Cannot find any revisions in FRX with id \"" + this.frxid + "\"");
            }
            this.frxDO = this.makeFRXDO(frx, true);
            if (this.isForcedDiffView()) {
                this.frxDO.setSideBySide(this.getSideBySide());
            }
            if (this.u != null) {
                this.frxDO.setDiffContext(this.u);
            }
            this.frxDO.setIgnore_BL(this.ignore_BL);
            this.frxDO.setIgnore_b(this.ignore_b);
            this.frxDO.setIgnore_w(this.ignore_w);
            FRXRevision to = this.toRev == null ? null : frxRevisionManager.getById(this.toRev);
            FRXRevision fRXRevision = from = this.fromRev == null ? null : frxRevisionManager.getById(this.fromRev);
            if (to != null) {
                this.frxDO.setToFrxRevision(to);
                this.frxDO.resetDiff();
            }
            if (from != null) {
                this.frxDO.setFromFrxRevision(from);
                this.frxDO.resetDiff();
            }
            this.frxDO.mapInlineComments();
            this.commitTx();
            String string = "success";
            return string;
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)("Problem creating FRXDO from frx " + this.frxid), (Throwable)e2);
            this.errorMsg = e2.getMessage();
            this.worked = false;
            String string = "error";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    public boolean isReloadReview() {
        return false;
    }
}

