/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.actions.StateActionAction;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.UserActionManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class StateActionAjaxAction
extends StateActionAction
implements AjaxResponse {
    private boolean worked = true;
    private static final Set<String> DASHBOARD_REDIRECT_COMMANDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(UserActionManager.ACTION_ABANDON, UserActionManager.ACTION_DELETE, UserActionManager.ACTION_REJECT)));
    private static final Set<String> REVIEW_REDIRECT_COMMANDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(UserActionManager.ACTION_SUMMARIZE, UserActionManager.ACTION_UNCOMPLETE, UserActionManager.ACTION_APPROVE, UserActionManager.ACTION_SUBMIT, UserActionManager.ACTION_CLOSE, UserActionManager.ACTION_REOPEN, UserActionManager.ACTION_RECOVER)));

    public boolean isConfirmationNeeded() {
        String command = this.getCommand();
        UserActionManager.Action action = UserActionManager.Action.getByName(command);
        boolean isReview = this.getReview().getType() == Review.ReviewType.REVIEW;
        return this.getConfirm() != null || isReview && action != null && action.isConfirmationNeeded();
    }

    public boolean isRedirect() {
        return !this.isConfirmationNeeded();
    }

    public boolean isRedirectToDashboard() {
        return this.isRedirect() && DASHBOARD_REDIRECT_COMMANDS.contains(this.getCommand());
    }

    public boolean isRedirectToReview() {
        return this.isRedirect() && REVIEW_REDIRECT_COMMANDS.contains(this.getCommand());
    }

    @Override
    public String getErrorMsg() {
        return this.getErrorDescription();
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    @Override
    public String execute() throws Exception {
        String result = super.execute();
        if (result.equals("error") || result.equals("AccessError")) {
            this.worked = false;
            return "error";
        }
        return "success";
    }
}

