/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.services.AuthorizationException;
import com.atlassian.crucible.spi.services.ReviewService;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.discussion.DiscussionClause;
import com.cenqua.crucible.model.discussion.DiscussionClauses;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.ReviewMutableProperties;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.base.Strings;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class StateActionAction
extends ReviewBaseAction {
    private String command;
    private boolean reviewUpdated;
    private String errorMsg = "You are not authorized to make the requested state change.";
    private String confirm;
    private String summary;
    @Autowired
    CommentManager commentManager;
    @Autowired
    ReviewService reviewService;
    @Autowired
    TxTemplate txTemplate;

    public String getConfirm() {
        return this.confirm;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setReviewUpdated(boolean reviewUpdated) {
        this.reviewUpdated = reviewUpdated;
    }

    public boolean isReviewUpdated() {
        return this.reviewUpdated;
    }

    public String getError() {
        return null;
    }

    public String getErrorDescription() {
        return this.errorMsg;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    private boolean hasCompleteWarnings() {
        return this.isReviewUpdated() || this.getReviewDO().getTotalUnreadCount() > 0 || this.getMyDraftCommentCount() > 0 || this.getIncompleteFileFrxCount() > 0;
    }

    private boolean hasSummarizeWarnings() {
        Review review = this.getReview();
        return this.isReviewUpdated() || review.getCountActiveReviewers() > 0 || !this.commentManager.comments(review).where(DiscussionClauses.and(DiscussionClauses.not(DiscussionClauses.deleted()), DiscussionClauses.draft(), new DiscussionClause[0])).isEmpty() || this.isCommentsWithUnresolvedSubtasks();
    }

    private boolean isCommentsWithUnresolvedSubtasks() {
        try {
            return this.hasCommentsWithUnresolvedSubtasks();
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Error retrieving subtask status from JIRA (on summarize)", (Throwable)e2);
            return true;
        }
    }

    public String execute() throws Exception {
        return this.txTemplate.execute(status -> {
            try {
                Review review = this.getReview();
                State state = review.getState();
                if (this.command.startsWith("action:") && !ReviewUtil.canDoReviewAction(this.command, review)) {
                    return "AccessError";
                }
                boolean isReviewState = state.isReviewState();
                if (isReviewState && this.command.equals(UserActionManager.ACTION_COMPLETE)) {
                    if (this.hasCompleteWarnings()) {
                        this.confirm = "complete";
                    } else {
                        this.reviewService.completeReview(review.getPermId(), true);
                    }
                    return this.command;
                }
                if (isReviewState && this.command.equals("forceComplete")) {
                    this.reviewService.completeReview(review.getPermId(), true);
                    this.command = UserActionManager.ACTION_COMPLETE;
                    return this.command;
                }
                if (isReviewState && this.command.equals(UserActionManager.ACTION_UNCOMPLETE)) {
                    this.reviewService.completeReview(review.getPermId(), false);
                    return this.command;
                }
                if (isReviewState && this.command.equals(UserActionManager.ACTION_SUMMARIZE) && this.hasSummarizeWarnings()) {
                    this.commitTx();
                    this.confirm = "summary";
                    return "confirm";
                }
                if (this.command.equals("forceSummarize")) {
                    this.command = UserActionManager.ACTION_SUMMARIZE;
                }
                if (this.command.equals(UserActionManager.ACTION_APPROVE) && review.getReviewers().size() == 0) {
                    this.confirm = "approve";
                    return "confirm";
                }
                if (this.command.equals(UserActionManager.ACTION_ABANDON)) {
                    this.confirm = "delete";
                    return "confirm";
                }
                if (this.command.equals("confirmApprove")) {
                    this.command = UserActionManager.ACTION_APPROVE;
                }
                if (this.command.equals("confirmDelete")) {
                    this.command = UserActionManager.ACTION_ABANDON;
                }
                if (this.command.equals(UserActionManager.ACTION_CLOSE) || this.command.equals(UserActionManager.ACTION_REOPEN)) {
                    if (review.getState().isReviewState() && this.hasSummarizeWarnings()) {
                        this.confirm = "close";
                        return "confirm";
                    }
                    if (!Strings.isNullOrEmpty((String)this.summary)) {
                        LogManager.logReviewPropertyChanged(ReviewMutableProperties.SUMMARY, review, this.getCurrentUser(), review.getSummary(), this.summary);
                        review.setSummary(this.summary);
                    }
                }
                if (this.command.equals("forceClose")) {
                    this.command = UserActionManager.ACTION_CLOSE;
                }
                if (this.command.equals(UserActionManager.ACTION_DELETE)) {
                    if (review.getState().isDeletable()) {
                        try {
                            this.reviewManager.deleteReview(review, this.getCurrentUser());
                            return this.command;
                        }
                        catch (Exception e2) {
                            Logs.APP_LOG.error((Object)"Error deleting review", (Throwable)e2);
                            this.errorMsg = "There was a problem deleting this review (" + review.getPermaId() + ")" + e2.getMessage();
                            return "error";
                        }
                    }
                    throw new AuthorizationException("Can't delete review in state " + review.getState().toString());
                }
                this.reviewService.changeState(new PermId(review.getPermaId()), this.command);
                return this.command;
            }
            catch (AuthorizationException ae2) {
                status.setRollbackOnly();
                this.errorMsg = ae2.getMessage();
                return "AccessError";
            }
        });
    }
}

