/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.atlassian.crucible.actions.ReviewBaseAction;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.LogAction;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.util.AlsoViewingCache;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;

public class ReviewUpdatedAjaxAction
extends ReviewBaseAction {
    @Resource
    private AlsoViewingCache alsoViewingCache;
    @Resource
    private UnreadManager unreadManager;
    @Resource
    private CommentManager commentManager;
    private boolean checkOwnActions;
    private Long reviewRenderTime = null;
    private String reviewStateName;
    private boolean stateChanged;
    private boolean detailsChanged;
    private boolean hasBeenUncompleted;
    private String errMsg = "";
    private boolean worked = true;
    private boolean reloadRequired;
    private Set<Integer> updatedFrxIds = new HashSet<Integer>();
    private Set<Integer> addedFrxIds = new HashSet<Integer>();
    private Set<Integer> removedFrxIds = new HashSet<Integer>();
    private Set<Integer> unreadFrxIds = new HashSet<Integer>();
    private Set<Integer> updatedReviewCommentIds = new HashSet<Integer>();
    private Set<Integer> updatedFileCommentIds = new HashSet<Integer>();
    private Set<Integer> updatedInlineCommentIds = new HashSet<Integer>();
    private Set<FecruUser> addedReviewers = new HashSet<FecruUser>();
    private Set<FecruUser> removedReviewers = new HashSet<FecruUser>();
    private FecruUser newAuthor;
    private FecruUser newModerator;
    private boolean roleChanged;
    private List<FecruUser> alsoViewing;
    private boolean backingOff;
    private Long timeSpent;
    private Set<FecruUser> usersAddedComments = new HashSet<FecruUser>();
    private Set<FecruUser> usersDeletedComments = new HashSet<FecruUser>();
    private int addedCommentCount = 0;
    private int deletedCommentCount = 0;
    private long lastLogItemTimestamp = -1L;
    private static final Set<String> detailChangingTypes = ImmutableSet.of((Object)LogAction.REVIEW_DESCRIPTION_CHANGED.getKey(), (Object)LogAction.REVIEW_TITLE_CHANGED.getKey(), (Object)LogAction.REVIEW_JIRA_KEY_CHANGED.getKey(), (Object)LogAction.REVIEW_JIRA_KEY_DELETED.getKey(), (Object)LogAction.REVIEW_PARENT_REVIEW_CHANGED.getKey(), (Object)LogAction.REVIEW_SUMMARY_CHANGED.getKey(), (Object[])new String[]{LogAction.REVIEW_DUE_DATE_CHANGED.getKey()});
    private static final Set<String> contentChangingTypes = ImmutableSet.of((Object)LogAction.COMMENT_ADDED.getKey(), (Object)LogAction.COMMENT_CHANGED.getKey(), (Object)LogAction.COMMENT_UPDATED.getKey(), (Object)LogAction.COMMENT_DELETED.getKey(), (Object)LogAction.REVIEW_FRX_ADDED.getKey(), (Object)LogAction.REVIEW_FRX_REMOVED.getKey(), (Object[])new String[]{LogAction.REVIEW_REVISION_ADDED.getKey(), LogAction.REVIEW_REVISION_REMOVED.getKey()});
    private static final Set<String> roleChangingTypes = ImmutableSet.of((Object)LogAction.REVIEW_AUTHOR_CHANGED.getKey(), (Object)LogAction.REVIEW_MODERATOR_CHANGED.getKey(), (Object)LogAction.REVIEW_REVIEWER_ADDED.getKey(), (Object)LogAction.REVIEW_REVIEWER_REMOVED.getKey(), (Object)LogAction.REVIEW_REVIEWER_ADDED_MID_REVIEW.getKey(), (Object)LogAction.REVIEW_REVIEWER_REMOVED_MID_REVIEW.getKey(), (Object[])new String[0]);
    private static final Set<String> externalTypes = ImmutableSet.of((Object)LogAction.EXTERNAL.getKey());

    public boolean isStateChanged() {
        return this.stateChanged;
    }

    public boolean isDetailsChanged() {
        return this.detailsChanged;
    }

    public int getAddedCommentCount() {
        return this.addedCommentCount;
    }

    public int getDeletedCommentCount() {
        return this.deletedCommentCount;
    }

    public Set<FecruUser> getUsersAddedComments() {
        return this.usersAddedComments;
    }

    public void setUsersAddedComments(Set<FecruUser> usersAddedComments) {
        this.usersAddedComments = usersAddedComments;
    }

    public Set<FecruUser> getUsersDeletedComments() {
        return this.usersDeletedComments;
    }

    public void setUsersDeletedComments(Set<FecruUser> usersDeletedComments) {
        this.usersDeletedComments = usersDeletedComments;
    }

    public void setCheckOwnActions(boolean checkOwnActions) {
        this.checkOwnActions = checkOwnActions;
    }

    public void setReviewRenderTime(long reviewRenderTime) {
        this.reviewRenderTime = reviewRenderTime;
    }

    public void setReviewStateName(String reviewStateName) {
        this.reviewStateName = reviewStateName;
    }

    public Set<Integer> getUpdatedReviewCommentIds() {
        return this.updatedReviewCommentIds;
    }

    public Set<Integer> getUpdatedFileCommentIds() {
        return this.updatedFileCommentIds;
    }

    public Set<Integer> getUpdatedInlineCommentIds() {
        return this.updatedInlineCommentIds;
    }

    public boolean isHasBeenUncompleted() {
        return this.hasBeenUncompleted;
    }

    public boolean isReloadRequired() {
        return this.reloadRequired;
    }

    public Set<Integer> getUpdatedFrxIds() {
        return this.updatedFrxIds;
    }

    public Set<Integer> getAddedFrxIds() {
        return this.addedFrxIds;
    }

    public Set<Integer> getRemovedFrxIds() {
        return this.removedFrxIds;
    }

    public Set<Integer> getUnreadFrxIds() {
        return this.unreadFrxIds;
    }

    public String getErrorMsg() {
        return this.errMsg;
    }

    public boolean isWorked() {
        return this.worked;
    }

    public Set<FecruUser> getAddedReviewers() {
        return this.addedReviewers;
    }

    public Set<FecruUser> getRemovedReviewers() {
        return this.removedReviewers;
    }

    public FecruUser getNewAuthor() {
        return this.newAuthor;
    }

    public boolean getHasNewAuthor() {
        return this.newAuthor != null;
    }

    public FecruUser getNewModerator() {
        return this.newModerator;
    }

    public boolean getHasNewModerator() {
        return this.newModerator != null;
    }

    public boolean isRoleChanged() {
        return this.roleChanged;
    }

    public List<FecruUser> getAlsoViewing() {
        return this.alsoViewing;
    }

    public void setBackingOff(boolean backingOff) {
        this.backingOff = backingOff;
    }

    public void setTimeSpent(Long timeSpent) {
        this.timeSpent = timeSpent;
    }

    public Long getTimeSpent() {
        return this.timeSpent;
    }

    public long getLastLogItemTimestamp() {
        return this.lastLogItemTimestamp;
    }

    public boolean getShowMessage() {
        return this.hasBeenUncompleted || this.reloadRequired || !this.updatedFrxIds.isEmpty() || !this.addedFrxIds.isEmpty() || !this.removedFrxIds.isEmpty() || !this.updatedFileCommentIds.isEmpty() || !this.updatedReviewCommentIds.isEmpty() || !this.updatedInlineCommentIds.isEmpty() || !this.addedReviewers.isEmpty() || !this.removedReviewers.isEmpty() || this.getHasNewAuthor() || this.getHasNewModerator() || this.roleChanged || this.detailsChanged;
    }

    private void checkReviewUpdated() {
        if (!this.getReview().getStateName().equals(this.reviewStateName)) {
            this.stateChanged = true;
            this.reloadRequired = true;
        }
        if (this.getParticipant() != null && !this.getParticipant().isAllComplete() && this.getParticipant().getCompletionStatusChangeDateTime() != null && this.getParticipant().getCompletionStatusChangeDateTime().compareTo(this.reviewRenderTime) > 0) {
            this.hasBeenUncompleted = true;
        }
        HashSet<String> types = new HashSet<String>();
        types.addAll(detailChangingTypes);
        types.addAll(contentChangingTypes);
        types.addAll(roleChangingTypes);
        types.addAll(externalTypes);
        List<LogItem> changes = LogManager.getLogForReview(this.getReviewid(), types, new Date(this.reviewRenderTime));
        for (LogItem item : changes) {
            this.checkLogItem(item);
        }
        this.updatedFrxIds.removeAll(this.removedFrxIds);
    }

    private void checkLogItem(LogItem logItem) {
        this.lastLogItemTimestamp = Math.max(this.lastLogItemTimestamp, logItem.getCreateDateTime());
        if (!this.checkOwnActions && this.getCurrentUser() != null && this.getCurrentUser().getId().equals(logItem.getUserId())) {
            return;
        }
        LogAction action = LogAction.valueOf(logItem.getAction());
        if (roleChangingTypes.contains(action.getKey()) && this.hasRoleChanged(logItem)) {
            this.roleChanged = true;
            this.reloadRequired = true;
        }
        if (detailChangingTypes.contains(action.getKey())) {
            if (LogAction.REVIEW_SUMMARY_CHANGED == action) {
                this.reloadRequired = true;
            }
            this.detailsChanged = true;
        } else {
            switch (action) {
                case COMMENT_ADDED: 
                case COMMENT_CHANGED: 
                case COMMENT_UPDATED: 
                case COMMENT_DELETED: 
                case COMMENT_REDRAFTED: {
                    this.checkCommentLogItem(logItem);
                    break;
                }
                case REVIEW_FRX_ADDED: {
                    this.addedFrxIds.add(logItem.getEntityId());
                    break;
                }
                case REVIEW_FRX_REMOVED: {
                    this.removedFrxIds.add(logItem.getEntityId());
                    break;
                }
                case REVIEW_REVISION_ADDED: 
                case REVIEW_REVISION_REMOVED: {
                    this.updatedFrxIds.add(logItem.getEntityId2());
                    break;
                }
                case REVIEW_AUTHOR_CHANGED: {
                    this.newAuthor = this.getReview().getAuthor();
                    break;
                }
                case REVIEW_MODERATOR_CHANGED: {
                    this.newModerator = this.getReview().getAuthor();
                    break;
                }
                case REVIEW_REVIEWER_ADDED: 
                case REVIEW_REVIEWER_ADDED_MID_REVIEW: {
                    this.addedReviewers.add(CrucibleUserManager.getUserById(logItem.getEntityId()));
                    break;
                }
                case REVIEW_REVIEWER_REMOVED: 
                case REVIEW_REVIEWER_REMOVED_MID_REVIEW: {
                    this.removedReviewers.add(CrucibleUserManager.getUserById(logItem.getEntityId()));
                }
            }
        }
    }

    private boolean hasRoleChanged(LogItem logItem) {
        if (this.getCurrentUser() == null) {
            return false;
        }
        String currentUser = this.getCurrentUser().getUsername();
        int currentUserId = this.getCurrentUser().getId();
        LogAction action = LogAction.valueOf(logItem.getAction());
        switch (action) {
            case REVIEW_AUTHOR_CHANGED: 
            case REVIEW_MODERATOR_CHANGED: {
                return currentUser.equals(logItem.getNewValue()) || currentUser.equals(logItem.getOldValue());
            }
            case REVIEW_REVIEWER_ADDED: 
            case REVIEW_REVIEWER_ADDED_MID_REVIEW: 
            case REVIEW_REVIEWER_REMOVED: 
            case REVIEW_REVIEWER_REMOVED_MID_REVIEW: {
                return currentUserId == logItem.getEntityId();
            }
        }
        return false;
    }

    private void checkCommentLogItem(LogItem logItem) {
        Comment c2 = this.commentManager.getById(logItem.getEntityId());
        if (c2 == null) {
            return;
        }
        switch (c2.getType()) {
            case GENERAL_COMMENT: {
                this.updatedReviewCommentIds.add(c2.getId());
                break;
            }
            case FRX_COMMENT: {
                this.updatedFileCommentIds.add(c2.getId());
                break;
            }
            case INLINE_COMMENT: {
                this.updatedInlineCommentIds.add(c2.getId());
            }
        }
        LogAction action = LogAction.valueOf(logItem.getAction());
        switch (action) {
            case COMMENT_ADDED: {
                ++this.addedCommentCount;
                this.usersAddedComments.add(c2.getUser());
                break;
            }
            case COMMENT_DELETED: 
            case COMMENT_REDRAFTED: {
                ++this.deletedCommentCount;
                this.usersDeletedComments.add(c2.getUser());
                break;
            }
        }
    }

    public String execute() throws Exception {
        if (this.reviewRenderTime == null) {
            this.errMsg = "Missing required parameter 'reviewRenderTime'.";
            this.worked = false;
            return "error";
        }
        try {
            this.beginTx();
            if (this.backingOff) {
                this.alsoViewing = Collections.emptyList();
            } else {
                this.alsoViewing = this.alsoViewingCache.updateAndGetUsersViewingReview(this.getReview().getPermaId(), this.getCurrentUser());
                ReviewParticipant participant = this.getReviewDO().getParticipant();
                if (participant != null) {
                    if (this.timeSpent == null || this.timeSpent < 0L) {
                        this.timeSpent = 0L;
                    }
                    Long storedTimeSpent = participant.getTimeSpent();
                    if (!this.getReview().getState().isClosedMetaState()) {
                        if (storedTimeSpent != null) {
                            this.timeSpent = this.timeSpent + storedTimeSpent;
                            if (this.timeSpent < storedTimeSpent) {
                                this.timeSpent = Long.MAX_VALUE;
                            }
                        }
                        participant.setTimeSpent(this.timeSpent);
                    } else {
                        this.timeSpent = storedTimeSpent != null ? storedTimeSpent : 0L;
                    }
                }
            }
            this.checkReviewUpdated();
            this.worked = true;
            this.commitTx();
            String string = "success";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

