/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.actions;

import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.StateManager;
import java.util.Date;

public class ReviewStateEvent {
    private String state;
    private final long timeStart;
    private final long timeEnd;
    private State stateObject;

    public ReviewStateEvent(String state, long timeStart, long timeEnd) {
        this.state = state;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.stateObject = StateManager.INSTANCE.getStateByName(state);
    }

    public String getState() {
        return this.state;
    }

    public String getTimeStartString() {
        return new Date(this.timeStart).toString();
    }

    public String getTimeEndString() {
        return new Date(this.timeEnd).toString();
    }

    public long getTimeStartLong() {
        return this.timeStart;
    }

    public long getTimeEndLong() {
        return this.timeEnd;
    }

    public String getStateVerbage() {
        if (this.stateObject.isUnknown()) {
            return this.state;
        }
        return this.stateObject.getVerbage();
    }

    public long getTimeStart() {
        return this.timeStart;
    }

    public long getTimeEnd() {
        return this.timeEnd;
    }
}

